/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.gui.history.CoordinateInfoViewer;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.NodeListViewer;
import org.openstreetmap.josm.gui.history.RelationMemberListViewer;
import org.openstreetmap.josm.gui.history.TagInfoViewer;
import org.openstreetmap.josm.gui.history.VersionTable;
import org.openstreetmap.josm.tools.I18n;

public class HistoryBrowser
extends JPanel {
    private transient HistoryBrowserModel model = new HistoryBrowserModel();
    private TagInfoViewer tagInfoViewer;
    private NodeListViewer nodeListViewer;
    private RelationMemberListViewer relationMemberListViewer;
    private CoordinateInfoViewer coordinateInfoViewer;
    private JTabbedPane tpViewers;

    public HistoryBrowser() {
        this.build();
    }

    public HistoryBrowser(History history) {
        this();
        this.populate(history);
    }

    protected JPanel createVersionTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(new VersionTable(this.model)), "Center");
        return jPanel;
    }

    protected JPanel createVersionComparePanel() {
        this.tpViewers = new JTabbedPane();
        this.tagInfoViewer = new TagInfoViewer(this.model);
        this.nodeListViewer = new NodeListViewer(this.model);
        this.relationMemberListViewer = new RelationMemberListViewer(this.model);
        this.coordinateInfoViewer = new CoordinateInfoViewer(this.model);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.tpViewers, "Center");
        this.tpViewers.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (HistoryBrowser.this.tpViewers.getSelectedComponent() == HistoryBrowser.this.coordinateInfoViewer) {
                    HistoryBrowser.this.coordinateInfoViewer.setDisplayToFitMapMarkers();
                }
            }
        });
        return jPanel;
    }

    protected void build() {
        JPanel jPanel = this.createVersionTablePanel();
        JPanel jPanel2 = this.createVersionComparePanel();
        this.setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, jPanel2);
        this.add((Component)jSplitPane, "Center");
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(300);
        Dimension dimension = new Dimension(100, 50);
        jPanel.setMinimumSize(dimension);
        jPanel2.setMinimumSize(dimension);
    }

    public void populate(History history) {
        this.model.setHistory(history);
        this.tpViewers.removeAll();
        this.tpViewers.add(this.tagInfoViewer);
        this.tpViewers.setTitleAt(0, I18n.tr("Tags", new Object[0]));
        if (history.getEarliest().getType().equals((Object)OsmPrimitiveType.NODE)) {
            this.tpViewers.add(this.coordinateInfoViewer);
            this.tpViewers.setTitleAt(1, I18n.tr("Coordinates", new Object[0]));
        } else if (history.getEarliest().getType().equals((Object)OsmPrimitiveType.WAY)) {
            this.tpViewers.add(this.nodeListViewer);
            this.tpViewers.setTitleAt(1, I18n.tr("Nodes", new Object[0]));
        } else if (history.getEarliest().getType().equals((Object)OsmPrimitiveType.RELATION)) {
            this.tpViewers.add(this.relationMemberListViewer);
            this.tpViewers.setTitleAt(1, I18n.tr("Members", new Object[0]));
        }
        this.revalidate();
    }

    public History getHistory() {
        return this.model.getHistory();
    }

    public HistoryBrowserModel getModel() {
        return this.model;
    }
}

