/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.awt.HeadlessException;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WMSImagery {
    private List<LayerDetails> layers;
    private URL serviceUrl;
    private List<String> formats;

    public List<LayerDetails> getLayers() {
        return this.layers;
    }

    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    public List<String> getFormats() {
        return Collections.unmodifiableList(this.formats);
    }

    public String getPreferredFormats() {
        return this.formats.contains("image/jpeg") ? "image/jpeg" : (this.formats.contains("image/png") ? "image/png" : (this.formats.isEmpty() ? null : this.formats.get(0)));
    }

    String buildRootUrl() {
        if (this.serviceUrl == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.serviceUrl.getProtocol());
        stringBuilder.append("://").append(this.serviceUrl.getHost());
        if (this.serviceUrl.getPort() != -1) {
            stringBuilder.append(':').append(this.serviceUrl.getPort());
        }
        stringBuilder.append(this.serviceUrl.getPath()).append('?');
        if (this.serviceUrl.getQuery() != null) {
            stringBuilder.append(this.serviceUrl.getQuery());
            if (!this.serviceUrl.getQuery().isEmpty() && !this.serviceUrl.getQuery().endsWith("&")) {
                stringBuilder.append('&');
            }
        }
        return stringBuilder.toString();
    }

    public String buildGetMapUrl(Collection<LayerDetails> collection) {
        return this.buildGetMapUrl(collection, "image/jpeg");
    }

    public String buildGetMapUrl(Collection<LayerDetails> collection, String string) {
        return this.buildRootUrl() + "FORMAT=" + string + (WMSImagery.imageFormatHasTransparency(string) ? "&TRANSPARENT=TRUE" : "") + "&VERSION=1.1.1&SERVICE=WMS&REQUEST=GetMap&LAYERS=" + Utils.join(",", Utils.transform(collection, new Utils.Function<LayerDetails, String>(){

            @Override
            public String apply(LayerDetails layerDetails) {
                return layerDetails.ident;
            }
        })) + "&STYLES=&SRS={proj}&WIDTH={width}&HEIGHT={height}&BBOX={bbox}";
    }

    public void attemptGetCapabilities(String string) throws MalformedURLException, IOException, WMSGetCapabilitiesException {
        URL uRL = null;
        try {
            uRL = !Pattern.compile(".*GetCapabilities.*", 2).matcher(string).matches() ? ((uRL = new URL(string)).getQuery() == null ? new URL(string + '?' + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities") : (!uRL.getQuery().isEmpty() && !uRL.getQuery().endsWith("&") ? new URL(string + '&' + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities") : new URL(string + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities"))) : new URL(string);
            this.serviceUrl = new URL(string);
        }
        catch (HeadlessException headlessException) {
            return;
        }
        Main.info("GET " + uRL);
        String string2 = HttpClient.create(uRL).connect().fetchContent();
        Main.debug("Server response to Capabilities request:");
        Main.debug(string2);
        try {
            Object object;
            DocumentBuilder documentBuilder = Utils.newSafeDOMBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    Main.info("Ignoring DTD " + string + ", " + string2);
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = documentBuilder.parse(new InputSource(new StringReader(string2)));
            Element element = WMSImagery.getChild(document.getDocumentElement(), "Capability");
            element = WMSImagery.getChild(element, "Request");
            element = WMSImagery.getChild(element, "GetMap");
            this.formats = new ArrayList<String>(Utils.filter(Utils.transform(WMSImagery.getChildren(element, "Format"), new Utils.Function<Element, String>(){

                @Override
                public String apply(Element element) {
                    return element.getTextContent();
                }
            }), new Predicate<String>(){

                @Override
                public boolean evaluate(String string) {
                    boolean bl = WMSImagery.isImageFormatSupported(string);
                    if (!bl) {
                        Main.info("Skipping unsupported image format {0}", string);
                    }
                    return bl;
                }
            }));
            element = WMSImagery.getChild(element, "DCPType");
            element = WMSImagery.getChild(element, "HTTP");
            element = WMSImagery.getChild(element, "Get");
            element = WMSImagery.getChild(element, "OnlineResource");
            if (element != null && (object = element.getAttribute("xlink:href")) != null && !((String)object).equals(string)) {
                Main.info("GetCapabilities specifies a different service URL: " + (String)object);
                this.serviceUrl = new URL((String)object);
            }
            object = WMSImagery.getChild(document.getDocumentElement(), "Capability");
            List<Element> list = WMSImagery.getChildren((Element)object, "Layer");
            this.layers = this.parseLayers(list, new HashSet<String>());
        }
        catch (MalformedURLException | ParserConfigurationException | SAXException exception) {
            throw new WMSGetCapabilitiesException(exception, string2);
        }
    }

    static boolean isImageFormatSupported(String string) {
        return ImageIO.getImageReadersByMIMEType(string).hasNext() || (string.startsWith("image/tiff") || string.startsWith("image/geotiff")) && ImageIO.getImageReadersBySuffix("tiff").hasNext() || string.startsWith("image/png") && ImageIO.getImageReadersBySuffix("png").hasNext() || string.startsWith("image/svg") && ImageIO.getImageReadersBySuffix("svg").hasNext() || string.startsWith("image/bmp") && ImageIO.getImageReadersBySuffix("bmp").hasNext();
    }

    static boolean imageFormatHasTransparency(String string) {
        return string != null && (string.startsWith("image/png") || string.startsWith("image/gif") || string.startsWith("image/svg") || string.startsWith("image/tiff"));
    }

    public ImageryInfo toImageryInfo(String string, Collection<LayerDetails> collection) {
        ImageryInfo imageryInfo = new ImageryInfo(string, this.buildGetMapUrl(collection));
        if (collection != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (LayerDetails layerDetails : collection) {
                hashSet.addAll(layerDetails.getProjections());
            }
            imageryInfo.setServerProjections(hashSet);
        }
        return imageryInfo;
    }

    private List<LayerDetails> parseLayers(List<Element> list, Set<String> set) {
        ArrayList<LayerDetails> arrayList = new ArrayList<LayerDetails>(list.size());
        for (Element element : list) {
            arrayList.add(this.parseLayer(element, set));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private LayerDetails parseLayer(Element element, Set<String> set) {
        void var8_14;
        String string = WMSImagery.getChildContent(element, "Title", null, null);
        String string2 = WMSImagery.getChildContent(element, "Name", null, null);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(set);
        List<Element> list = WMSImagery.getChildren(element, "CRS");
        list.addAll(WMSImagery.getChildren(element, "SRS"));
        for (Element object22 : list) {
            String string3 = (String)WMSImagery.getContent(object22);
            if (string3.isEmpty()) continue;
            String string4 = string3.trim().toUpperCase(Locale.ENGLISH);
            hashSet.add(string4);
        }
        boolean bl = false;
        for (String string5 : hashSet) {
            bl |= WMSImagery.isProjSupported(string5);
        }
        Object var8_11 = null;
        Element element2 = WMSImagery.getChild(element, "EX_GeographicBoundingBox");
        if (element2 != null) {
            double d = Double.parseDouble(WMSImagery.getChildContent(element2, "westBoundLongitude", null, null));
            double d2 = Double.parseDouble(WMSImagery.getChildContent(element2, "northBoundLatitude", null, null));
            double d3 = Double.parseDouble(WMSImagery.getChildContent(element2, "eastBoundLongitude", null, null));
            double d4 = Double.parseDouble(WMSImagery.getChildContent(element2, "southBoundLatitude", null, null));
            Bounds bounds = new Bounds(d4, d, d2, d3);
        } else {
            Element element3 = WMSImagery.getChild(element, "LatLonBoundingBox");
            if (element3 != null) {
                double d = Double.parseDouble(element3.getAttribute("minx"));
                double d5 = Double.parseDouble(element3.getAttribute("maxy"));
                double d6 = Double.parseDouble(element3.getAttribute("maxx"));
                double d7 = Double.parseDouble(element3.getAttribute("miny"));
                Bounds bounds = new Bounds(d7, d, d5, d6);
            }
        }
        List<Element> list2 = WMSImagery.getChildren(element, "Layer");
        List<LayerDetails> list3 = this.parseLayers(list2, hashSet);
        return new LayerDetails(string, string2, hashSet, bl, (Bounds)var8_14, list3);
    }

    private static boolean isProjSupported(String string) {
        return Projections.getProjectionByCode(string) != null;
    }

    private static String getChildContent(Element element, String string, String string2, String string3) {
        Element element2 = WMSImagery.getChild(element, string);
        if (element2 == null) {
            return string2;
        }
        String string4 = (String)WMSImagery.getContent(element2);
        return !string4.isEmpty() ? string4 : string3;
    }

    private static Object getContent(Element element) {
        NodeList nodeList = element.getChildNodes();
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    return node;
                }
                case 3: 
                case 4: {
                    stringBuilder.append(node.getNodeValue());
                    continue block4;
                }
            }
        }
        return stringBuilder.toString().trim();
    }

    private static List<Element> getChildren(Element element, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !string.equals(node.getNodeName())) continue;
            arrayList.add((Element)node);
        }
        return arrayList;
    }

    private static Element getChild(Element element, String string) {
        if (element == null) {
            return null;
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !string.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static class LayerDetails {
        public final String name;
        public final String ident;
        public final List<LayerDetails> children;
        public final Bounds bounds;
        public final Set<String> crsList;
        public final boolean supported;

        public LayerDetails(String string, String string2, Set<String> set, boolean bl, Bounds bounds, List<LayerDetails> list) {
            this.name = string;
            this.ident = string2;
            this.supported = bl;
            this.children = list;
            this.bounds = bounds;
            this.crsList = set;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public Set<String> getProjections() {
            return this.crsList;
        }

        public String toString() {
            if (this.name == null || this.name.isEmpty()) {
                return this.ident;
            }
            return this.name;
        }
    }

    public static class WMSGetCapabilitiesException
    extends Exception {
        private final String incomingData;

        public WMSGetCapabilitiesException(Throwable throwable, String string) {
            super(throwable);
            this.incomingData = string;
        }

        public String getIncomingData() {
            return this.incomingData;
        }
    }
}

