/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.ffi.CallingConvention;
import jnr.ffi.Library;
import jnr.ffi.LibraryOption;
import jnr.ffi.Memory;
import jnr.ffi.NativeLong;
import jnr.ffi.Platform;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.Direct;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;
import jnr.netdb.StringUtil;

abstract class NativeProtocolsDB
implements ProtocolsDB {
    NativeProtocolsDB() {
    }

    public static final NativeProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static final NativeProtocolsDB load() {
        try {
            LibProto lib;
            Platform.OS os = Platform.getNativePlatform().getOS();
            if (!(os.equals((Object)Platform.OS.DARWIN) || os.equals((Object)Platform.OS.WINDOWS) && Platform.getNativePlatform().getCPU() == Platform.CPU.I386 || os.equals((Object)Platform.OS.LINUX) || os.equals((Object)Platform.OS.SOLARIS) || os.equals((Object)Platform.OS.FREEBSD) || os.equals((Object)Platform.OS.NETBSD))) {
                return null;
            }
            if (os.equals((Object)Platform.OS.WINDOWS)) {
                HashMap<LibraryOption, CallingConvention> options2 = new HashMap<LibraryOption, CallingConvention>();
                options2.put(LibraryOption.CallingConvention, CallingConvention.STDCALL);
                lib = Library.loadLibrary(LibProto.class, options2, "Ws2_32");
            } else {
                String[] stringArray;
                if (os.equals((Object)Platform.OS.SOLARIS)) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "socket";
                    stringArray2[1] = "nsl";
                    stringArray = stringArray2;
                    stringArray2[2] = "c";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "c";
                }
                String[] libnames = stringArray;
                lib = os.equals((Object)Platform.OS.LINUX) ? (LibProto)Library.loadLibrary(LinuxLibProto.class, libnames) : Library.loadLibrary(LibProto.class, libnames);
            }
            NativeProtocolsDB protocolsDB = os.equals((Object)Platform.OS.LINUX) ? new LinuxNativeProtocolsDB((LinuxLibProto)lib) : new DefaultNativeProtocolsDB(lib);
            protocolsDB.getProtocolByName("ip");
            protocolsDB.getProtocolByNumber(0);
            return protocolsDB;
        }
        catch (Throwable t) {
            Logger.getLogger(NativeProtocolsDB.class.getName()).log(Level.WARNING, "Failed to load native protocols db", t);
            return null;
        }
    }

    static Protocol protocolFromNative(UnixProtoent p2) {
        if (p2 == null) {
            return null;
        }
        List emptyAliases = Collections.emptyList();
        Pointer ptr = p2.aliases.get();
        List<String> aliases2 = ptr != null ? StringUtil.getNullTerminatedStringArray(ptr) : emptyAliases;
        return new Protocol(p2.name.get(), (short)p2.proto.get(), aliases2);
    }

    static /* synthetic */ NativeProtocolsDB access$000() {
        return NativeProtocolsDB.load();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LinuxNativeProtocolsDB
    extends NativeProtocolsDB {
        private static final int BUFLEN = 4096;
        private final Runtime runtime;
        private final Pointer buf;
        private final LinuxLibProto lib;

        LinuxNativeProtocolsDB(LinuxLibProto lib) {
            this.lib = lib;
            this.runtime = Library.getRuntime(lib);
            this.buf = Memory.allocateDirect(this.runtime, 4096);
        }

        @Override
        public synchronized Protocol getProtocolByName(String name2) {
            UnixProtoent protoent = new UnixProtoent(this.runtime);
            Pointer result2 = Memory.allocateDirect(this.runtime, this.runtime.addressSize());
            if (this.lib.getprotobyname_r(name2, protoent, this.buf, new NativeLong(4096), result2) == 0) {
                return result2.getPointer(0L) != null ? LinuxNativeProtocolsDB.protocolFromNative(protoent) : null;
            }
            throw new RuntimeException("getprotobyname_r failed");
        }

        @Override
        public synchronized Protocol getProtocolByNumber(Integer number) {
            UnixProtoent protoent = new UnixProtoent(this.runtime);
            Pointer result2 = Memory.allocateDirect(this.runtime, this.runtime.addressSize());
            if (this.lib.getprotobynumber_r(number, protoent, this.buf, new NativeLong(4096), result2) == 0) {
                return result2.getPointer(0L) != null ? LinuxNativeProtocolsDB.protocolFromNative(protoent) : null;
            }
            throw new RuntimeException("getprotobynumber_r failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Collection<Protocol> getAllProtocols() {
            UnixProtoent p2 = new UnixProtoent(this.runtime);
            ArrayList<Protocol> allProtocols = new ArrayList<Protocol>();
            Pointer result2 = Memory.allocateDirect(this.runtime, this.runtime.addressSize());
            NativeLong buflen = new NativeLong(4096);
            this.lib.setprotoent(0);
            try {
                while (this.lib.getprotoent_r(p2, this.buf, buflen, result2) == 0 && result2.getPointer(0L) != null) {
                    allProtocols.add(LinuxNativeProtocolsDB.protocolFromNative(p2));
                }
            }
            finally {
                this.lib.endprotoent();
            }
            return allProtocols;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DefaultNativeProtocolsDB
    extends NativeProtocolsDB {
        private final LibProto lib;

        DefaultNativeProtocolsDB(LibProto lib) {
            this.lib = lib;
        }

        @Override
        public synchronized Protocol getProtocolByName(String name2) {
            return DefaultNativeProtocolsDB.protocolFromNative(this.lib.getprotobyname(name2));
        }

        @Override
        public synchronized Protocol getProtocolByNumber(Integer proto) {
            return DefaultNativeProtocolsDB.protocolFromNative(this.lib.getprotobynumber(proto));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Collection<Protocol> getAllProtocols() {
            ArrayList<Protocol> allProtocols = new ArrayList<Protocol>();
            this.lib.setprotoent(0);
            try {
                UnixProtoent p2;
                while ((p2 = this.lib.getprotoent()) != null) {
                    allProtocols.add(DefaultNativeProtocolsDB.protocolFromNative(p2));
                }
            }
            finally {
                this.lib.endprotoent();
            }
            return allProtocols;
        }
    }

    public static interface LinuxLibProto
    extends LibProto {
        public int getprotobyname_r(String var1, @Direct UnixProtoent var2, Pointer var3, NativeLong var4, Pointer var5);

        public int getprotobynumber_r(int var1, @Direct UnixProtoent var2, Pointer var3, NativeLong var4, Pointer var5);

        public int getprotoent_r(@Direct UnixProtoent var1, Pointer var2, NativeLong var3, Pointer var4);
    }

    public static interface LibProto {
        public UnixProtoent getprotobyname(String var1);

        public UnixProtoent getprotobynumber(int var1);

        public UnixProtoent getprotoent();

        public void setprotoent(int var1);

        public void endprotoent();
    }

    public static class UnixProtoent
    extends Struct {
        public final Struct.String name = new Struct.UTF8StringRef(this);
        public final Struct.Pointer aliases = new Struct.Pointer(this);
        public final Struct.Signed32 proto = new Struct.Signed32(this);

        public UnixProtoent(Runtime runtime) {
            super(runtime);
        }
    }

    private static final class SingletonHolder {
        public static final NativeProtocolsDB INSTANCE = NativeProtocolsDB.access$000();

        private SingletonHolder() {
        }
    }
}

