/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"LocalJumpError"}, parent="StandardError")
public class RubyLocalJumpError
extends RubyException {
    private static ObjectAllocator LOCALJUMPERROR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyLocalJumpError(runtime, klass);
        }
    };
    private Reason reason;

    public static RubyClass createLocalJumpErrorClass(Ruby runtime, RubyClass standardErrorClass) {
        RubyClass nameErrorClass = runtime.defineClass("LocalJumpError", standardErrorClass, LOCALJUMPERROR_ALLOCATOR);
        nameErrorClass.defineAnnotatedMethods(RubyLocalJumpError.class);
        return nameErrorClass;
    }

    private RubyLocalJumpError(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass);
    }

    public RubyLocalJumpError(Ruby runtime, RubyClass exceptionClass, String message2, Reason reason2, IRubyObject exitValue) {
        super(runtime, exceptionClass, message2);
        this.reason = reason2;
        this.setInternalVariable("reason", runtime.newSymbol(reason2.toString()));
        this.setInternalVariable("exit_value", exitValue);
    }

    @JRubyMethod
    public IRubyObject reason() {
        return (IRubyObject)this.getInternalVariable("reason");
    }

    public Reason getReason() {
        return this.reason;
    }

    @JRubyMethod
    public IRubyObject exit_value() {
        return (IRubyObject)this.getInternalVariable("exit_value");
    }

    public static enum Reason {
        REDO,
        BREAK,
        NEXT,
        RETURN,
        RETRY,
        NOREASON;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

