/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.opto;

import java.lang.invoke.MethodHandles;
import org.jruby.RubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.opto.FailoverSwitchPointInvalidator;
import org.jruby.runtime.opto.GenerationAndSwitchPointInvalidator;
import org.jruby.runtime.opto.GenerationInvalidator;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.SwitchPointInvalidator;
import org.jruby.util.cli.Options;

public class OptoFactory {
    private static final ConstantFactory CONSTANT_FACTORY = Options.COMPILE_INVOKEDYNAMIC.load() != false ? new MethodHandleConstantFactory() : new DummyConstantFactory();

    public static final Object newConstantWrapper(Class type2, Object object) {
        return CONSTANT_FACTORY.create(type2, object);
    }

    public static Invalidator newConstantInvalidator() {
        return new SwitchPointInvalidator();
    }

    private static Boolean indyEnabled() {
        return Options.COMPILE_INVOKEDYNAMIC.load();
    }

    public static Invalidator newGlobalInvalidator(int maxFailures) {
        return new FailoverSwitchPointInvalidator(maxFailures);
    }

    public static Invalidator newMethodInvalidator(RubyModule module) {
        if (OptoFactory.indyEnabled().booleanValue()) {
            try {
                return new GenerationAndSwitchPointInvalidator(module);
            }
            catch (Error e) {
                OptoFactory.disableIndy();
                throw e;
            }
            catch (Throwable t) {
                OptoFactory.disableIndy();
            }
        }
        return new GenerationInvalidator(module);
    }

    private static Boolean indyConstants() {
        return Options.INVOKEDYNAMIC_CACHE_CONSTANTS.load();
    }

    private static void disableIndy() {
        Options.COMPILE_INVOKEDYNAMIC.force("false");
    }

    private static class DummyConstantFactory
    implements ConstantFactory {
        private DummyConstantFactory() {
        }

        @Override
        public Object create(Class type2, Object object) {
            return null;
        }
    }

    private static class MethodHandleConstantFactory
    implements ConstantFactory {
        private MethodHandleConstantFactory() {
        }

        @Override
        public Object create(Class type2, Object object) {
            return MethodHandles.dropArguments(MethodHandles.constant(type2, object), 0, new Class[]{ThreadContext.class});
        }
    }

    public static interface ConstantFactory {
        public Object create(Class var1, Object var2);
    }
}

