/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.vm.ContextStore;
import com.oracle.truffle.api.vm.ContextStoreProfile;
import com.oracle.truffle.api.vm.ExecutionImpl;
import java.util.HashMap;
import java.util.Map;

final class ContextReference<C> {
    private static Map<TruffleLanguage<?>, Integer> ids = new HashMap();
    private final ContextStoreProfile profile;
    private final TruffleLanguage<C> language;
    private final int languageId;

    private ContextReference(ContextStoreProfile profile, TruffleLanguage<C> language, int languageId) {
        this.profile = profile;
        this.language = language;
        this.languageId = languageId;
    }

    public C get() {
        ContextStore store = this.profile.get();
        Object context = store.getContext(this.languageId);
        if (context == this) {
            return null;
        }
        if (context == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            context = ExecutionImpl.findContext(store.vm, this.language.getClass());
            store.setContext(this.languageId, context == null ? this : context);
        }
        return (C)context;
    }

    public static synchronized <C> ContextReference<C> create(TruffleLanguage<C> language) {
        Integer id = ids.get(language);
        if (id == null) {
            id = ids.size();
            ids.put(language, id);
        }
        return new ContextReference<C>(ExecutionImpl.sharedProfile(), language, id);
    }
}

