/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayGeneralizeNode;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ArrayGeneralizeNode.class)
public final class ArrayGeneralizeNodeGen
extends ArrayGeneralizeNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode requiredCapacity_;
    @CompilerDirectives.CompilationFinal
    private Class<?> requiredCapacityType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayGeneralizeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        super(context, sourceSection);
        this.array_ = array;
        this.requiredCapacity_ = requiredCapacity;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object[] executeGeneralize(DynamicObject arrayValue, int requiredCapacityValue) {
        return this.specialization_.executeObjectArray1(arrayValue, requiredCapacityValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public Object[] executeObjectArray(VirtualFrame frameValue) {
        return this.specialization_.executeObjectArray0(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ArrayGeneralizeNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        return new ArrayGeneralizeNodeGen(context, sourceSection, array, requiredCapacity);
    }

    @GeneratedBy(methodName="generalize(DynamicObject, int, ArrayStrategy, ConditionProfile)", value=ArrayGeneralizeNode.class)
    private static final class GeneralizeNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        private final ConditionProfile extendProfile;
        private final Class<?> requiredCapacityImplicitType;

        GeneralizeNode_(ArrayGeneralizeNodeGen root, Object requiredCapacityValue, ArrayStrategy strategy, ConditionProfile extendProfile) {
            super(root, 2);
            this.requiredCapacityImplicitType = RubyTypesGen.getImplicitIntegerClass(requiredCapacityValue);
            this.strategy = strategy;
            this.extendProfile = extendProfile;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.requiredCapacityImplicitType == ((GeneralizeNode_)other).requiredCapacityImplicitType;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            DynamicObject arrayValue_;
            return arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType) && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeObjectArray0(frameValue);
        }

        @Override
        public Object[] executeObjectArray0(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeObjectArray_(ex.getResult(), requiredCapacityValue);
            }
            try {
                if (this.requiredCapacityImplicitType == Integer.TYPE) {
                    requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
                } else {
                    Object requiredCapacityValue__ = this.executeRequiredCapacity_(frameValue);
                    requiredCapacityValue_ = RubyTypesGen.expectImplicitInteger(requiredCapacityValue__, this.requiredCapacityImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeObjectArray_(arrayValue_, ex.getResult());
            }
            if (this.strategy.matches(arrayValue_)) {
                return this.root.generalize(arrayValue_, requiredCapacityValue_, this.strategy, this.extendProfile);
            }
            return this.getNext().executeObjectArray_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object[] executeObjectArray1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (this.strategy.matches(arrayValue)) {
                return this.root.generalize(arrayValue, requiredCapacityValue, this.strategy, this.extendProfile);
            }
            return this.getNext().executeObjectArray1(arrayValue, requiredCapacityValue);
        }

        @Override
        public Object[] executeObjectArray_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = RubyTypesGen.asImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType);
                if (this.strategy.matches(arrayValue_)) {
                    return this.root.generalize(arrayValue_, requiredCapacityValue_, this.strategy, this.extendProfile);
                }
            }
            return this.getNext().executeObjectArray_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayGeneralizeNodeGen root, Object requiredCapacityValue, ArrayStrategy strategy, ConditionProfile extendProfile) {
            return new GeneralizeNode_(root, requiredCapacityValue, strategy, extendProfile);
        }
    }

    @GeneratedBy(methodName="generalizeNull(DynamicObject, int)", value=ArrayGeneralizeNode.class)
    private static final class GeneralizeNullNode_
    extends BaseNode_ {
        private final Class<?> requiredCapacityImplicitType;

        GeneralizeNullNode_(ArrayGeneralizeNodeGen root, Object requiredCapacityValue) {
            super(root, 1);
            this.requiredCapacityImplicitType = RubyTypesGen.getImplicitIntegerClass(requiredCapacityValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.requiredCapacityImplicitType == ((GeneralizeNullNode_)other).requiredCapacityImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeObjectArray0(frameValue);
        }

        @Override
        public Object[] executeObjectArray0(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_(frameValue);
                return this.getNext().executeObjectArray_(ex.getResult(), requiredCapacityValue);
            }
            try {
                if (this.requiredCapacityImplicitType == Integer.TYPE) {
                    requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
                } else {
                    Object requiredCapacityValue__ = this.executeRequiredCapacity_(frameValue);
                    requiredCapacityValue_ = RubyTypesGen.expectImplicitInteger(requiredCapacityValue__, this.requiredCapacityImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeObjectArray_(arrayValue_, ex.getResult());
            }
            if (ArrayGuards.isNullArray(arrayValue_)) {
                return this.root.generalizeNull(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeObjectArray_(arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object[] executeObjectArray1(DynamicObject arrayValue, int requiredCapacityValue) {
            if (ArrayGuards.isNullArray(arrayValue)) {
                return this.root.generalizeNull(arrayValue, requiredCapacityValue);
            }
            return this.getNext().executeObjectArray1(arrayValue, requiredCapacityValue);
        }

        @Override
        public Object[] executeObjectArray_(Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = RubyTypesGen.asImplicitInteger(requiredCapacityValue, this.requiredCapacityImplicitType);
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return this.root.generalizeNull(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeObjectArray_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayGeneralizeNodeGen root, Object requiredCapacityValue) {
            return new GeneralizeNullNode_(root, requiredCapacityValue);
        }
    }

    @GeneratedBy(value=ArrayGeneralizeNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayGeneralizeNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, requiredCapacityValue));
        }

        @Override
        public Object[] executeObjectArray_(Object arrayValue, Object requiredCapacityValue) {
            return this.getNext().executeObjectArray_(arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayGeneralizeNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayGeneralizeNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayGeneralizeNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object[] executeObjectArray_(Object arrayValue, Object requiredCapacityValue) {
            return (Object[])this.uninitialized((Frame)null, arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(ArrayGeneralizeNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayGeneralizeNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayGeneralizeNodeGen root;

        BaseNode_(ArrayGeneralizeNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ArrayGeneralizeNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.requiredCapacity_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.executeObjectArray_(arrayValue, requiredCapacityValue);
        }

        public abstract Object[] executeObjectArray_(Object var1, Object var2);

        public Object[] executeObjectArray1(DynamicObject arrayValue, int requiredCapacityValue) {
            return this.executeObjectArray_(arrayValue, requiredCapacityValue);
        }

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object requiredCapacityValue_ = this.executeRequiredCapacity_(frameValue);
            return this.executeObjectArray_(arrayValue_, requiredCapacityValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public Object[] executeObjectArray0(VirtualFrame frameValue) {
            return (Object[])this.execute(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(requiredCapacityValue)) {
                ConditionProfile extendProfile2;
                BaseNode_ s;
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return GeneralizeNullNode_.create(this.root, requiredCapacityValue);
                }
                ArrayStrategy strategy2 = ArrayStrategy.of(arrayValue_);
                if (strategy2.matches(arrayValue_) && this.countSame(s = GeneralizeNode_.create(this.root, requiredCapacityValue, strategy2, extendProfile2 = ConditionProfile.createCountingProfile())) < 25) {
                    return s;
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeRequiredCapacity_(Frame frameValue) {
            Object object;
            Class requiredCapacityType_ = this.root.requiredCapacityType_;
            if (requiredCapacityType_ == Integer.TYPE) {
                return this.root.requiredCapacity_.executeInteger((VirtualFrame)frameValue);
            }
            if (requiredCapacityType_ != null) return this.root.requiredCapacity_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.requiredCapacity_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.requiredCapacityType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.requiredCapacityType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.requiredCapacityType_ = _type;
            return object;
        }
    }
}

