/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class)})
public abstract class ArrayReadNormalizedNode
extends RubyNode {
    public ArrayReadNormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeRead(DynamicObject var1, int var2);

    @Specialization(guards={"isNullArray(array)"})
    public DynamicObject readNull(DynamicObject array, int index) {
        return this.nil();
    }

    @Specialization(guards={"isInBounds(array, index)", "strategy.matches(array)"}, limit="ARRAY_STRATEGIES")
    public Object readInBounds(DynamicObject array, int index, @Cached(value="of(array)") ArrayStrategy strategy) {
        return strategy.newMirror(array).get(index);
    }

    @Specialization(guards={"!isInBounds(array, index)"})
    public DynamicObject readOutOfBounds(DynamicObject array, int index) {
        return this.nil();
    }

    protected static boolean isInBounds(DynamicObject array, int index) {
        return index >= 0 && index < Layouts.ARRAY.getSize(array);
    }
}

