/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.DoubleArrayMirror;
import org.jruby.truffle.core.array.EmptyArrayMirror;
import org.jruby.truffle.core.array.IntegerArrayMirror;
import org.jruby.truffle.core.array.LongArrayMirror;
import org.jruby.truffle.core.array.ObjectArrayMirror;

public abstract class ArrayReflector {
    public static IntegerArrayMirror reflect(int[] array) {
        return new IntegerArrayMirror(array);
    }

    public static LongArrayMirror reflect(long[] array) {
        return new LongArrayMirror(array);
    }

    public static DoubleArrayMirror reflect(double[] array) {
        return new DoubleArrayMirror(array);
    }

    public static ObjectArrayMirror reflect(Object[] array) {
        return new ObjectArrayMirror(array);
    }

    public static ArrayMirror reflect(Object array) {
        if (array == null) {
            return new EmptyArrayMirror();
        }
        if (array instanceof int[]) {
            return ArrayReflector.reflect((int[])array);
        }
        if (array instanceof long[]) {
            return ArrayReflector.reflect((long[])array);
        }
        if (array instanceof double[]) {
            return ArrayReflector.reflect((double[])array);
        }
        if (array.getClass() == Object[].class) {
            return ArrayReflector.reflect((Object[])array);
        }
        throw new UnsupportedOperationException();
    }
}

