/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;

@NodeChild(value="child", type=RubyNode.class)
public abstract class SingleValueCastNode
extends RubyNode {
    public SingleValueCastNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract Object executeSingleValue(VirtualFrame var1, Object[] var2);

    @Specialization(guards={"noArguments(args)"})
    protected DynamicObject castNil(Object[] args) {
        return this.nil();
    }

    @Specialization(guards={"singleArgument(args)"})
    protected Object castSingle(Object[] args) {
        return args[0];
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!noArguments(args)", "!singleArgument(args)"})
    protected DynamicObject castMany(Object[] args) {
        return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), args, args.length);
    }

    protected boolean noArguments(Object[] args) {
        return args.length == 0;
    }

    protected boolean singleArgument(Object[] args) {
        return args.length == 1;
    }
}

