/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.proc;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.proc.ProcLayout;
import org.jruby.truffle.language.control.FrameOnStackMarker;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.SharedMethodInfo;

@GeneratedBy(value=ProcLayout.class)
public class ProcLayoutImpl
extends BasicObjectLayoutImpl
implements ProcLayout {
    public static final ProcLayout INSTANCE = new ProcLayoutImpl();
    protected static final Shape.Allocator PROC_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey TYPE_IDENTIFIER = new HiddenKey("type");
    protected static final Property TYPE_PROPERTY = Property.create(TYPE_IDENTIFIER, PROC_ALLOCATOR.locationForType(org.jruby.truffle.core.proc.ProcType.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey SHARED_METHOD_INFO_IDENTIFIER = new HiddenKey("sharedMethodInfo");
    protected static final Property SHARED_METHOD_INFO_PROPERTY = Property.create(SHARED_METHOD_INFO_IDENTIFIER, PROC_ALLOCATOR.locationForType(SharedMethodInfo.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey CALL_TARGET_FOR_TYPE_IDENTIFIER = new HiddenKey("callTargetForType");
    protected static final Property CALL_TARGET_FOR_TYPE_PROPERTY = Property.create(CALL_TARGET_FOR_TYPE_IDENTIFIER, PROC_ALLOCATOR.locationForType(CallTarget.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey CALL_TARGET_FOR_LAMBDAS_IDENTIFIER = new HiddenKey("callTargetForLambdas");
    protected static final Property CALL_TARGET_FOR_LAMBDAS_PROPERTY = Property.create(CALL_TARGET_FOR_LAMBDAS_IDENTIFIER, PROC_ALLOCATOR.locationForType(CallTarget.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey DECLARATION_FRAME_IDENTIFIER = new HiddenKey("declarationFrame");
    protected static final Property DECLARATION_FRAME_PROPERTY = Property.create(DECLARATION_FRAME_IDENTIFIER, PROC_ALLOCATOR.locationForType(MaterializedFrame.class, EnumSet.of(LocationModifier.Final)), 0);
    protected static final HiddenKey METHOD_IDENTIFIER = new HiddenKey("method");
    protected static final Property METHOD_PROPERTY = Property.create(METHOD_IDENTIFIER, PROC_ALLOCATOR.locationForType(InternalMethod.class, EnumSet.of(LocationModifier.Final)), 0);
    protected static final HiddenKey SELF_IDENTIFIER = new HiddenKey("self");
    protected static final Property SELF_PROPERTY = Property.create(SELF_IDENTIFIER, PROC_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)), 0);
    protected static final HiddenKey BLOCK_IDENTIFIER = new HiddenKey("block");
    protected static final Property BLOCK_PROPERTY = Property.create(BLOCK_IDENTIFIER, PROC_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.Final)), 0);
    protected static final HiddenKey FRAME_ON_STACK_MARKER_IDENTIFIER = new HiddenKey("frameOnStackMarker");
    protected static final Property FRAME_ON_STACK_MARKER_PROPERTY = Property.create(FRAME_ON_STACK_MARKER_IDENTIFIER, PROC_ALLOCATOR.locationForType(FrameOnStackMarker.class, EnumSet.of(LocationModifier.Final)), 0);

    protected ProcLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createProcShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new ProcType(logicalClass, metaClass)).addProperty(TYPE_PROPERTY).addProperty(SHARED_METHOD_INFO_PROPERTY).addProperty(CALL_TARGET_FOR_TYPE_PROPERTY).addProperty(CALL_TARGET_FOR_LAMBDAS_PROPERTY).addProperty(DECLARATION_FRAME_PROPERTY).addProperty(METHOD_PROPERTY).addProperty(SELF_PROPERTY).addProperty(BLOCK_PROPERTY).addProperty(FRAME_ON_STACK_MARKER_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createProc(DynamicObjectFactory factory, org.jruby.truffle.core.proc.ProcType type, SharedMethodInfo sharedMethodInfo, CallTarget callTargetForType, CallTarget callTargetForLambdas, MaterializedFrame declarationFrame, InternalMethod method, Object self, DynamicObject block, FrameOnStackMarker frameOnStackMarker) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsProc(factory));
        assert (factory.getShape().hasProperty(TYPE_IDENTIFIER));
        assert (factory.getShape().hasProperty(SHARED_METHOD_INFO_IDENTIFIER));
        assert (factory.getShape().hasProperty(CALL_TARGET_FOR_TYPE_IDENTIFIER));
        assert (factory.getShape().hasProperty(CALL_TARGET_FOR_LAMBDAS_IDENTIFIER));
        assert (factory.getShape().hasProperty(DECLARATION_FRAME_IDENTIFIER));
        assert (factory.getShape().hasProperty(METHOD_IDENTIFIER));
        assert (factory.getShape().hasProperty(SELF_IDENTIFIER));
        assert (factory.getShape().hasProperty(BLOCK_IDENTIFIER));
        assert (factory.getShape().hasProperty(FRAME_ON_STACK_MARKER_IDENTIFIER));
        assert (type != null);
        assert (sharedMethodInfo != null);
        assert (callTargetForType != null);
        assert (callTargetForLambdas != null);
        assert (self != null);
        return factory.newInstance(new Object[]{type, sharedMethodInfo, callTargetForType, callTargetForLambdas, declarationFrame, method, self, block, frameOnStackMarker});
    }

    @Override
    public boolean isProc(Object object) {
        return object instanceof DynamicObject && this.isProc((DynamicObject)object);
    }

    @Override
    public boolean isProc(DynamicObject object) {
        return this.isProc(object.getShape().getObjectType());
    }

    @Override
    public boolean isProc(ObjectType objectType) {
        return objectType instanceof ProcType;
    }

    private boolean createsProc(DynamicObjectFactory factory) {
        return this.isProc(factory.getShape().getObjectType());
    }

    @Override
    public org.jruby.truffle.core.proc.ProcType getType(DynamicObject object) {
        assert (this.isProc(object));
        assert (object.getShape().hasProperty(TYPE_IDENTIFIER));
        return (org.jruby.truffle.core.proc.ProcType)((Object)TYPE_PROPERTY.get(object, this.isProc(object)));
    }

    @Override
    public SharedMethodInfo getSharedMethodInfo(DynamicObject object) {
        assert (this.isProc(object));
        assert (object.getShape().hasProperty(SHARED_METHOD_INFO_IDENTIFIER));
        return (SharedMethodInfo)SHARED_METHOD_INFO_PROPERTY.get(object, this.isProc(object));
    }

    @Override
    public CallTarget getCallTargetForType(DynamicObject object) {
        assert (this.isProc(object));
        assert (object.getShape().hasProperty(CALL_TARGET_FOR_TYPE_IDENTIFIER));
        return (CallTarget)CALL_TARGET_FOR_TYPE_PROPERTY.get(object, this.isProc(object));
    }

    @Override
    public CallTarget getCallTargetForLambdas(DynamicObject object) {
        assert (this.isProc(object));
        assert (object.getShape().hasProperty(CALL_TARGET_FOR_LAMBDAS_IDENTIFIER));
        return (CallTarget)CALL_TARGET_FOR_LAMBDAS_PROPERTY.get(object, this.isProc(object));
    }

    @Override
    public MaterializedFrame getDeclarationFrame(DynamicObject object) {
        assert (this.isProc(object));
        assert (object.getShape().hasProperty(DECLARATION_FRAME_IDENTIFIER));
        return (MaterializedFrame)DECLARATION_FRAME_PROPERTY.get(object, this.isProc(object));
    }

    @Override
    public InternalMethod getMethod(DynamicObject object) {
        assert (this.isProc(object));
        assert (object.getShape().hasProperty(METHOD_IDENTIFIER));
        return (InternalMethod)METHOD_PROPERTY.get(object, this.isProc(object));
    }

    @Override
    public Object getSelf(DynamicObject object) {
        assert (this.isProc(object));
        assert (object.getShape().hasProperty(SELF_IDENTIFIER));
        return SELF_PROPERTY.get(object, this.isProc(object));
    }

    @Override
    public DynamicObject getBlock(DynamicObject object) {
        assert (this.isProc(object));
        assert (object.getShape().hasProperty(BLOCK_IDENTIFIER));
        return (DynamicObject)BLOCK_PROPERTY.get(object, this.isProc(object));
    }

    @Override
    public FrameOnStackMarker getFrameOnStackMarker(DynamicObject object) {
        assert (this.isProc(object));
        assert (object.getShape().hasProperty(FRAME_ON_STACK_MARKER_IDENTIFIER));
        return (FrameOnStackMarker)FRAME_ON_STACK_MARKER_PROPERTY.get(object, this.isProc(object));
    }

    public static class ProcType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public ProcType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public ProcType setLogicalClass(DynamicObject logicalClass) {
            return new ProcType(logicalClass, this.metaClass);
        }

        @Override
        public ProcType setMetaClass(DynamicObject metaClass) {
            return new ProcType(this.logicalClass, metaClass);
        }
    }
}

