/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.rubinius.AtomicReferenceLayout;

@GeneratedBy(value=AtomicReferenceLayout.class)
public class AtomicReferenceLayoutImpl
extends BasicObjectLayoutImpl
implements AtomicReferenceLayout {
    public static final AtomicReferenceLayout INSTANCE = new AtomicReferenceLayoutImpl();
    protected static final Shape.Allocator ATOMIC_REFERENCE_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey VALUE_IDENTIFIER = new HiddenKey("value");
    protected static final Property VALUE_PROPERTY = Property.create(VALUE_IDENTIFIER, ATOMIC_REFERENCE_ALLOCATOR.locationForType(AtomicReference.class, EnumSet.of(LocationModifier.NonNull)), 0);

    protected AtomicReferenceLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createAtomicReferenceShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new AtomicReferenceType(logicalClass, metaClass)).addProperty(VALUE_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createAtomicReference(DynamicObjectFactory factory, Object value) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (AtomicReferenceLayoutImpl.createsAtomicReference(factory));
        assert (factory.getShape().hasProperty(VALUE_IDENTIFIER));
        assert (value != null);
        return factory.newInstance(new AtomicReference<Object>(value));
    }

    private static boolean isAtomicReference(DynamicObject object) {
        return AtomicReferenceLayoutImpl.isAtomicReference(object.getShape().getObjectType());
    }

    private static boolean isAtomicReference(ObjectType objectType) {
        return objectType instanceof AtomicReferenceType;
    }

    private static boolean createsAtomicReference(DynamicObjectFactory factory) {
        return AtomicReferenceLayoutImpl.isAtomicReference(factory.getShape().getObjectType());
    }

    @Override
    public Object getValue(DynamicObject object) {
        assert (AtomicReferenceLayoutImpl.isAtomicReference(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        return ((AtomicReference)VALUE_PROPERTY.get(object, AtomicReferenceLayoutImpl.isAtomicReference(object))).get();
    }

    @Override
    public void setValue(DynamicObject object, Object value) {
        assert (AtomicReferenceLayoutImpl.isAtomicReference(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        assert (value != null);
        ((AtomicReference)VALUE_PROPERTY.get(object, AtomicReferenceLayoutImpl.isAtomicReference(object))).set(value);
    }

    @Override
    public boolean compareAndSetValue(DynamicObject object, Object expected_value, Object value) {
        assert (AtomicReferenceLayoutImpl.isAtomicReference(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        assert (value != null);
        return ((AtomicReference)VALUE_PROPERTY.get(object, AtomicReferenceLayoutImpl.isAtomicReference(object))).compareAndSet(expected_value, value);
    }

    @Override
    public Object getAndSetValue(DynamicObject object, Object value) {
        assert (AtomicReferenceLayoutImpl.isAtomicReference(object));
        assert (object.getShape().hasProperty(VALUE_IDENTIFIER));
        assert (value != null);
        return ((AtomicReference)VALUE_PROPERTY.get(object, AtomicReferenceLayoutImpl.isAtomicReference(object))).getAndSet(value);
    }

    public static class AtomicReferenceType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public AtomicReferenceType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public AtomicReferenceType setLogicalClass(DynamicObject logicalClass) {
            return new AtomicReferenceType(logicalClass, this.metaClass);
        }

        @Override
        public AtomicReferenceType setMetaClass(DynamicObject metaClass) {
            return new AtomicReferenceType(this.logicalClass, metaClass);
        }
    }
}

