/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.time;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joda.time.DateTimeZone;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.constants.ReadLiteralConstantNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.literal.ObjectLiteralNode;

public class ReadTimeZoneNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode hashNode;
    @Node.Child
    private ReadLiteralConstantNode envNode;
    private final ConditionProfile tzNilProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile tzStringProfile = ConditionProfile.createBinaryProfile();
    private static final Rope defaultZone = StringOperations.encodeRope(DateTimeZone.getDefault().toString(), (Encoding)UTF8Encoding.INSTANCE);
    private final DynamicObject TZ;

    public ReadTimeZoneNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.envNode = new ReadLiteralConstantNode(context, sourceSection, new ObjectLiteralNode(context, sourceSection, this.coreLibrary().getObjectClass()), "ENV");
        this.TZ = this.create7BitString("TZ", (Encoding)UTF8Encoding.INSTANCE);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object tz = this.hashNode.call(frame, this.envNode.execute(frame), "[]", null, this.TZ);
        if (this.tzNilProfile.profile(tz == this.nil())) {
            return this.createString(defaultZone);
        }
        if (this.tzStringProfile.profile(RubyGuards.isRubyString(tz))) {
            return tz;
        }
        throw new UnsupportedOperationException();
    }
}

