/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Map;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.hash.HashOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.ReadUserKeywordsHashNode;

public class ReadKeywordArgumentNode
extends RubyNode {
    private final String name;
    private final ConditionProfile defaultProfile = ConditionProfile.createBinaryProfile();
    @Node.Child
    private RubyNode defaultValue;
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;

    public ReadKeywordArgumentNode(RubyContext context, SourceSection sourceSection, int minimum, String name, RubyNode defaultValue) {
        super(context, sourceSection);
        this.name = name;
        this.defaultValue = defaultValue;
        this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode(minimum);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject hash = (DynamicObject)this.readUserKeywordsHashNode.execute(frame);
        if (this.defaultProfile.profile(hash == null)) {
            return this.defaultValue.execute(frame);
        }
        Object value = this.lookupKeywordInHash(hash);
        if (this.defaultProfile.profile(value == null)) {
            return this.defaultValue.execute(frame);
        }
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    private Object lookupKeywordInHash(DynamicObject hash) {
        assert (RubyGuards.isRubyHash(hash));
        for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(hash)) {
            if (!RubyGuards.isRubySymbol(keyValue.getKey()) || !keyValue.getKey().toString().equals(this.name)) continue;
            return keyValue.getValue();
        }
        return null;
    }
}

