/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import org.jruby.truffle.language.locals.ReadFrameSlotNode;

@GeneratedBy(value=ReadFrameSlotNode.class)
public final class ReadFrameSlotNodeGen
extends ReadFrameSlotNode
implements SpecializedNode {
    @CompilerDirectives.CompilationFinal
    private boolean excludeReadBoolean_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeReadInt_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeReadLong_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeReadDouble_;
    @CompilerDirectives.CompilationFinal
    private boolean excludeReadObject_;
    @Node.Child
    private BaseNode_ specialization_ = UninitializedNode_.create(this);

    private ReadFrameSlotNodeGen(FrameSlot slot) {
        super(slot);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeRead(Frame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ReadFrameSlotNode create(FrameSlot slot) {
        return new ReadFrameSlotNodeGen(slot);
    }

    @GeneratedBy(methodName="readAny(Frame)", value=ReadFrameSlotNode.class)
    private static final class ReadAnyNode_
    extends BaseNode_ {
        ReadAnyNode_(ReadFrameSlotNodeGen root) {
            super(root, 6);
        }

        @Override
        public Object execute(Frame frameValue) {
            return this.root.readAny(frameValue);
        }

        static BaseNode_ create(ReadFrameSlotNodeGen root) {
            return new ReadAnyNode_(root);
        }
    }

    @GeneratedBy(methodName="readObject(Frame)", value=ReadFrameSlotNode.class)
    private static final class ReadObjectNode_
    extends BaseNode_ {
        ReadObjectNode_(ReadFrameSlotNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute(Frame frameValue) {
            try {
                return this.root.readObject(frameValue);
            }
            catch (FrameSlotTypeException ex) {
                this.root.excludeReadObject_ = true;
                return this.remove("threw rewrite exception", frameValue);
            }
        }

        static BaseNode_ create(ReadFrameSlotNodeGen root) {
            return new ReadObjectNode_(root);
        }
    }

    @GeneratedBy(methodName="readDouble(Frame)", value=ReadFrameSlotNode.class)
    private static final class ReadDoubleNode_
    extends BaseNode_ {
        ReadDoubleNode_(ReadFrameSlotNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute(Frame frameValue) {
            try {
                return this.root.readDouble(frameValue);
            }
            catch (FrameSlotTypeException ex) {
                this.root.excludeReadDouble_ = true;
                return this.remove("threw rewrite exception", frameValue);
            }
        }

        static BaseNode_ create(ReadFrameSlotNodeGen root) {
            return new ReadDoubleNode_(root);
        }
    }

    @GeneratedBy(methodName="readLong(Frame)", value=ReadFrameSlotNode.class)
    private static final class ReadLongNode_
    extends BaseNode_ {
        ReadLongNode_(ReadFrameSlotNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute(Frame frameValue) {
            try {
                return this.root.readLong(frameValue);
            }
            catch (FrameSlotTypeException ex) {
                this.root.excludeReadLong_ = true;
                return this.remove("threw rewrite exception", frameValue);
            }
        }

        static BaseNode_ create(ReadFrameSlotNodeGen root) {
            return new ReadLongNode_(root);
        }
    }

    @GeneratedBy(methodName="readInt(Frame)", value=ReadFrameSlotNode.class)
    private static final class ReadIntNode_
    extends BaseNode_ {
        ReadIntNode_(ReadFrameSlotNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute(Frame frameValue) {
            try {
                return this.root.readInt(frameValue);
            }
            catch (FrameSlotTypeException ex) {
                this.root.excludeReadInt_ = true;
                return this.remove("threw rewrite exception", frameValue);
            }
        }

        static BaseNode_ create(ReadFrameSlotNodeGen root) {
            return new ReadIntNode_(root);
        }
    }

    @GeneratedBy(methodName="readBoolean(Frame)", value=ReadFrameSlotNode.class)
    private static final class ReadBooleanNode_
    extends BaseNode_ {
        ReadBooleanNode_(ReadFrameSlotNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(Frame frameValue) {
            try {
                return this.root.readBoolean(frameValue);
            }
            catch (FrameSlotTypeException ex) {
                this.root.excludeReadBoolean_ = true;
                return this.remove("threw rewrite exception", frameValue);
            }
        }

        static BaseNode_ create(ReadFrameSlotNodeGen root) {
            return new ReadBooleanNode_(root);
        }
    }

    @GeneratedBy(value=ReadFrameSlotNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ReadFrameSlotNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute(Frame frameValue) {
            return this.uninitialized(frameValue);
        }

        static BaseNode_ create(ReadFrameSlotNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ReadFrameSlotNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ReadFrameSlotNodeGen root;

        BaseNode_(ReadFrameSlotNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ReadFrameSlotNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[0];
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue) {
            return this.execute(frameValue);
        }

        public abstract Object execute(Frame var1);

        @Override
        protected final SpecializationNode createNext(Frame frameValue) {
            if (!this.root.excludeReadBoolean_) {
                return ReadBooleanNode_.create(this.root);
            }
            if (!this.root.excludeReadInt_) {
                return ReadIntNode_.create(this.root);
            }
            if (!this.root.excludeReadLong_) {
                return ReadLongNode_.create(this.root);
            }
            if (!this.root.excludeReadDouble_) {
                return ReadDoubleNode_.create(this.root);
            }
            if (!this.root.excludeReadObject_) {
                return ReadObjectNode_.create(this.root);
            }
            return ReadAnyNode_.create(this.root);
        }
    }
}

