/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform.sunmisc;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jruby.truffle.platform.signal.Signal;
import org.jruby.truffle.platform.signal.SignalManager;
import org.jruby.truffle.platform.sunmisc.SunMiscSignal;
import sun.misc.SignalHandler;

public class SunMiscSignalManager
implements SignalManager {
    private final ConcurrentMap<sun.misc.Signal, SignalHandler> DEFAULT_HANDLERS = new ConcurrentHashMap<sun.misc.Signal, SignalHandler>();

    @Override
    public Signal createSignal(String name) {
        return new SunMiscSignal(name);
    }

    @Override
    public void watchSignal(Signal signal, org.jruby.truffle.platform.signal.SignalHandler newHandler) throws IllegalArgumentException {
        this.handle(signal, newHandler);
    }

    @Override
    public void watchDefaultForSignal(Signal signal) throws IllegalArgumentException {
        this.handleDefault(signal);
    }

    @Override
    public void handle(Signal signal, org.jruby.truffle.platform.signal.SignalHandler newHandler) throws IllegalArgumentException {
        SunMiscSignal smSignal = (SunMiscSignal)signal;
        SignalHandler oldSunHandler = sun.misc.Signal.handle(smSignal.getSunMiscSignal(), this.wrapHandler(signal, newHandler));
        this.DEFAULT_HANDLERS.putIfAbsent(smSignal.getSunMiscSignal(), oldSunHandler);
    }

    @Override
    public void handleDefault(Signal signal) throws IllegalArgumentException {
        SunMiscSignal smSignal = (SunMiscSignal)signal;
        SignalHandler defaultHandler = (SignalHandler)this.DEFAULT_HANDLERS.get(smSignal.getSunMiscSignal());
        if (defaultHandler != null) {
            sun.misc.Signal.handle(smSignal.getSunMiscSignal(), defaultHandler);
        }
    }

    private SignalHandler wrapHandler(Signal signal, final org.jruby.truffle.platform.signal.SignalHandler newHandler) {
        final SunMiscSignal smSignal = (SunMiscSignal)signal;
        return new SignalHandler(){

            @Override
            public void handle(sun.misc.Signal wrappedSignal) {
                newHandler.handle(smSignal);
            }
        };
    }

    @Override
    public void raise(Signal signal) throws IllegalArgumentException {
        sun.misc.Signal.raise(((SunMiscSignal)signal).getSunMiscSignal());
    }
}

