/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report;

import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.report.JFreeReportCoreModule;
import org.jfree.report.JFreeReportInfo;
import org.jfree.report.util.CSVTokenizer;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.boot.PackageManager;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.base.config.PropertyFileConfiguration;
import org.pentaho.reporting.libraries.base.config.SystemPropertyConfiguration;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

public class JFreeReportBoot
extends AbstractBoot {
    private static final Log logger = LogFactory.getLog(JFreeReportBoot.class);
    private static JFreeReportBoot instance;
    private ProjectInformation projectInfo = JFreeReportInfo.getInstance();
    private static transient UserConfigWrapper configWrapper;

    private JFreeReportBoot() {
    }

    public static synchronized JFreeReportBoot getInstance() {
        if (instance == null) {
            instance = new JFreeReportBoot();
        }
        return instance;
    }

    public ModifiableConfiguration getEditableConfig() {
        return (ModifiableConfiguration)this.getGlobalConfig();
    }

    protected ProjectInformation getProjectInfo() {
        return this.projectInfo;
    }

    protected Configuration loadConfiguration() {
        HierarchicalConfiguration hierarchicalConfiguration = new HierarchicalConfiguration();
        PropertyFileConfiguration propertyFileConfiguration = new PropertyFileConfiguration();
        propertyFileConfiguration.load("/org/jfree/report/jfreereport.properties");
        propertyFileConfiguration.load("/org/jfree/report/ext/jfreereport-ext.properties");
        hierarchicalConfiguration.insertConfiguration((HierarchicalConfiguration)propertyFileConfiguration);
        hierarchicalConfiguration.insertConfiguration((HierarchicalConfiguration)JFreeReportBoot.getInstance().getPackageManager().getPackageConfiguration());
        PropertyFileConfiguration propertyFileConfiguration2 = new PropertyFileConfiguration();
        propertyFileConfiguration2.load("/jfreereport.properties");
        hierarchicalConfiguration.insertConfiguration((HierarchicalConfiguration)propertyFileConfiguration2);
        hierarchicalConfiguration.insertConfiguration((HierarchicalConfiguration)configWrapper);
        SystemPropertyConfiguration systemPropertyConfiguration = new SystemPropertyConfiguration();
        hierarchicalConfiguration.insertConfiguration((HierarchicalConfiguration)systemPropertyConfiguration);
        return hierarchicalConfiguration;
    }

    protected void performBoot() {
        if (!JFreeReportBoot.isStrictFP()) {
            logger.warn((Object)"The used VM seems to use a non-strict floating point arithmetics");
            logger.warn((Object)"Layouts computed with this Java Virtual Maschine may be invalid.");
            logger.warn((Object)"JFreeReport and the library 'iText' depend on the strict floating point rules");
            logger.warn((Object)"of Java1.1 as implemented by the Sun Virtual Maschines.");
            logger.warn((Object)"If you are using the BEA JRockit VM, start the Java VM with the option");
            logger.warn((Object)"'-Xstrictfp' to restore the default behaviour.");
        }
        PackageManager packageManager = this.getPackageManager();
        packageManager.addModule(JFreeReportCoreModule.class.getName());
        packageManager.load("org.jfree.report.modules.");
        packageManager.load("org.jfree.report.ext.modules.");
        packageManager.load("org.jfree.report.userdefined.modules.");
        this.bootAdditionalModules();
        packageManager.initializeModules();
    }

    private void bootAdditionalModules() {
        try {
            String string = this.getGlobalConfig().getConfigProperty("org.jfree.report.boot.Modules");
            if (string != null) {
                CSVTokenizer cSVTokenizer = new CSVTokenizer(string, ",");
                while (cSVTokenizer.hasMoreTokens()) {
                    String string2 = cSVTokenizer.nextToken();
                    this.getPackageManager().load(string2);
                }
            }
        }
        catch (SecurityException securityException) {
            logger.info((Object)"Security settings forbid to check the system properties for extension modules.");
        }
        catch (Exception exception) {
            logger.error((Object)"An error occured while checking the system properties for extension modules.", (Throwable)exception);
        }
    }

    private static boolean isStrictFP() {
        return true;
    }

    public static Configuration getUserConfig() {
        return configWrapper.getWrappedConfiguration();
    }

    public static void setUserConfig(Configuration configuration) {
        configWrapper.setWrappedConfiguration(configuration);
    }

    static {
        configWrapper = new UserConfigWrapper();
    }

    private static class UserConfigWrapper
    extends HierarchicalConfiguration
    implements Configuration {
        private Configuration wrappedConfiguration;

        public UserConfigWrapper() {
            this(null);
        }

        public UserConfigWrapper(Configuration configuration) {
            this.wrappedConfiguration = configuration;
        }

        public void setWrappedConfiguration(Configuration configuration) {
            this.wrappedConfiguration = configuration;
        }

        public Configuration getWrappedConfiguration() {
            return this.wrappedConfiguration;
        }

        public String getConfigProperty(String string) {
            if (this.wrappedConfiguration == null) {
                return this.getParentConfig().getConfigProperty(string);
            }
            String string2 = this.wrappedConfiguration.getConfigProperty(string);
            if (string2 != null) {
                return string2;
            }
            return this.getParentConfig().getConfigProperty(string);
        }

        public String getConfigProperty(String string, String string2) {
            if (this.wrappedConfiguration == null) {
                return this.getParentConfig().getConfigProperty(string, string2);
            }
            String string3 = this.wrappedConfiguration.getConfigProperty(string, null);
            if (string3 != null) {
                return string3;
            }
            return this.getParentConfig().getConfigProperty(string, string2);
        }

        public void setConfigProperty(String string, String string2) {
            if (this.wrappedConfiguration instanceof ModifiableConfiguration) {
                ModifiableConfiguration modifiableConfiguration = (ModifiableConfiguration)this.wrappedConfiguration;
                modifiableConfiguration.setConfigProperty(string, string2);
            }
        }

        public Enumeration getConfigProperties() {
            if (this.wrappedConfiguration instanceof ModifiableConfiguration) {
                ModifiableConfiguration modifiableConfiguration = (ModifiableConfiguration)this.wrappedConfiguration;
                return modifiableConfiguration.getConfigProperties();
            }
            return super.getConfigProperties();
        }
    }
}

