/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.adapter;

import com.sun.star.io.IOException;
import com.sun.star.io.XInputStream;
import java.io.InputStream;

public final class InputStreamToXInputStreamAdapter
implements XInputStream {
    private final InputStream iIn;

    public InputStreamToXInputStreamAdapter(InputStream inputStream) {
        this.iIn = inputStream;
    }

    public int available() throws IOException {
        int n;
        try {
            n = this.iIn.available();
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException);
        }
        return n;
    }

    public void closeInput() throws IOException {
        try {
            this.iIn.close();
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException);
        }
    }

    public int readBytes(byte[][] byArray, int n) throws IOException {
        try {
            long l = n > this.iIn.available() ? (long)this.iIn.read(byArray[0], 0, this.iIn.available()) : (long)this.iIn.read(byArray[0], 0, n);
            if (l <= 0L) {
                return 0;
            }
            return (int)l;
        }
        catch (java.io.IOException iOException) {
            throw new IOException("reader error", (Object)iOException);
        }
    }

    public int readSomeBytes(byte[][] byArray, int n) throws IOException {
        try {
            long l = n > this.iIn.available() ? (long)this.iIn.read(byArray[0], 0, this.iIn.available()) : (long)this.iIn.read(byArray[0], 0, n);
            if (l <= 0L) {
                return 0;
            }
            return (int)l;
        }
        catch (java.io.IOException iOException) {
            throw new IOException("reader error", (Object)iOException);
        }
    }

    public void skipBytes(int n) throws IOException {
        try {
            this.iIn.available();
        }
        catch (java.io.IOException iOException) {
            throw new IOException(iOException);
        }
        do {
            try {
                n = (int)((long)n - this.iIn.skip(n));
            }
            catch (java.io.IOException iOException) {
                throw new IOException(iOException);
            }
        } while (n > 0);
    }
}

