/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.NumberSequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class CountFunction
implements Function {
    public String getCanonicalName() {
        return "COUNT";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount == 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        int count = 0;
        for (int paramIdx = 0; paramIdx < parameterCount; ++paramIdx) {
            try {
                Type type = parameters.getType(paramIdx);
                Object value = parameters.getValue(paramIdx);
                NumberSequence sequence = context.getTypeRegistry().convertToNumberSequence(type, value, true);
                while (sequence.hasNext()) {
                    sequence.next();
                    ++count;
                }
                continue;
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(count));
    }
}

