/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.typing.ExtendedComparator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class DefaultComparator
implements ExtendedComparator {
    private FormulaContext context;
    private static final int LESS = -1;
    private static final int EQUAL = 0;
    private static final int MORE = 1;

    public void inititalize(FormulaContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
    }

    public boolean isEqual(Type type1, Object value1, Type type2, Object value2) {
        if (ObjectUtilities.equal((Object)value1, (Object)value2)) {
            return true;
        }
        TypeRegistry typeRegistry = this.context.getTypeRegistry();
        if (type1.isFlagSet("type.numeric") || type2.isFlagSet("type.numeric")) {
            try {
                Number number1 = typeRegistry.convertToNumber(type1, value1);
                Number number2 = typeRegistry.convertToNumber(type2, value2);
                BigDecimal bd1 = NumberUtil.getAsBigDecimal(number1);
                BigDecimal bd2 = NumberUtil.getAsBigDecimal(number2);
                if (bd1.signum() != bd2.signum()) {
                    return false;
                }
                return bd1.compareTo(bd2) == 0;
            }
            catch (EvaluationException number1) {
                // empty catch block
            }
        }
        if (type1.isFlagSet("type.text") || type2.isFlagSet("type.text")) {
            String text1 = null;
            String text2 = null;
            try {
                text1 = typeRegistry.convertToText(type1, value1);
                text2 = typeRegistry.convertToText(type2, value2);
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
            if (text1 == null && text2 == null) {
                return true;
            }
            if (text1 == null || text2 == null) {
                return false;
            }
            return ObjectUtilities.equal((Object)text1, (Object)text2);
        }
        return ObjectUtilities.equal((Object)value1, (Object)value2);
    }

    public int compare(Type type1, Object value1, Type type2, Object value2) {
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        if (type1.isFlagSet("type.scalar") && type2.isFlagSet("type.scalar") && value1 instanceof Comparable && value2 instanceof Comparable) {
            Comparable c1 = (Comparable)value1;
            try {
                int result = c1.compareTo(value2);
                if (result == 0) {
                    return 0;
                }
                if (result > 0) {
                    return 1;
                }
                return -1;
            }
            catch (Exception result) {
                // empty catch block
            }
        }
        TypeRegistry typeRegistry = this.context.getTypeRegistry();
        if (type1.isFlagSet("type.numeric") || type2.isFlagSet("type.numeric")) {
            try {
                int result;
                Number number1 = typeRegistry.convertToNumber(type1, value1);
                Number number2 = typeRegistry.convertToNumber(type2, value2);
                BigDecimal bd1 = NumberUtil.getAsBigDecimal(number1);
                BigDecimal bd2 = NumberUtil.getAsBigDecimal(number2);
                if (bd1.signum() != bd2.signum()) {
                    if (bd1.signum() < 0) {
                        return -1;
                    }
                    if (bd1.signum() > 0) {
                        return 1;
                    }
                }
                if ((result = bd1.compareTo(bd2)) == 0) {
                    return 0;
                }
                if (result > 0) {
                    return 1;
                }
                return -1;
            }
            catch (EvaluationException number1) {
                // empty catch block
            }
        }
        String text1 = null;
        String text2 = null;
        try {
            text1 = typeRegistry.convertToText(type1, value1);
            text2 = typeRegistry.convertToText(type2, value2);
        }
        catch (EvaluationException bd1) {
            // empty catch block
        }
        if (text1 == null && text2 == null) {
            return 0;
        }
        if (text1 == null) {
            return -1;
        }
        if (text2 == null) {
            return 1;
        }
        int result = text1.compareTo(text2);
        if (result == 0) {
            return 0;
        }
        if (result > 0) {
            return 1;
        }
        return -1;
    }
}

