/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.util.Arrays;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.msgpack.jruby.Encoder;

public class CoreExtensions {
    public static void load(final Ruby ruby) {
        List<RubyClass> list = Arrays.asList(ruby.getNilClass(), ruby.getTrueClass(), ruby.getFalseClass(), ruby.getFixnum(), ruby.getBignum(), ruby.getFloat(), ruby.getString(), ruby.getArray(), ruby.getHash(), ruby.getSymbol());
        for (RubyClass rubyClass : list) {
            rubyClass.addMethod("to_msgpack", new DynamicMethod((RubyModule)rubyClass, Visibility.PUBLIC, CallConfiguration.FrameNoneScopeNone){

                public IRubyObject call(ThreadContext threadContext, IRubyObject iRubyObject, RubyModule rubyModule, String string, IRubyObject[] iRubyObjectArray, Block block) {
                    RubyString rubyString = (RubyString)new Encoder(ruby).encode(iRubyObject);
                    if (0 < iRubyObjectArray.length) {
                        IRubyObject iRubyObject2 = iRubyObjectArray[0];
                        if (iRubyObject2 instanceof RubyIO) {
                            RubyIO rubyIO = (RubyIO)iRubyObject2;
                            rubyIO.write(threadContext, (IRubyObject)rubyString);
                            return threadContext.nil;
                        }
                        if (iRubyObject2 instanceof RubyString) {
                            RubyString rubyString2 = (RubyString)iRubyObject2;
                            rubyString2.cat(rubyString.getByteList());
                            return threadContext.nil;
                        }
                        if (iRubyObject2 instanceof RubyArray) {
                            RubyArray rubyArray = (RubyArray)iRubyObject2;
                            rubyArray.append((IRubyObject)rubyString);
                            return threadContext.nil;
                        }
                    }
                    return rubyString;
                }

                public DynamicMethod dup() {
                    return this;
                }
            });
        }
    }
}

