/*
 * Decompiled with CFR 0.152.
 */
package com.concurrent_ruby.ext;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.unsafe.UnsafeHolder;

public class SynchronizationLibrary
implements Library {
    private static final ObjectAllocator JRUBYREFERENCE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new JavaObject(ruby, rubyClass);
        }
    };

    public void load(Ruby ruby, boolean bl) throws IOException {
        RubyModule rubyModule = ruby.defineModule("Concurrent").defineModuleUnder("Synchronization");
        RubyClass rubyClass = rubyModule.getClass("AbstractObject");
        if (rubyClass == null) {
            throw ruby.newRuntimeError("Concurrent::Synchronization::AbstractObject is missing");
        }
        RubyClass rubyClass2 = rubyModule.defineClassUnder("JavaObject", rubyClass, JRUBYREFERENCE_ALLOCATOR);
        rubyClass2.defineAnnotatedMethods(JavaObject.class);
    }

    @JRubyClass(name={"JavaObject"}, parent="AbstractObject")
    public static class JavaObject
    extends RubyObject {
        public static final long AN_VOLATILE_FIELD_OFFSET = UnsafeHolder.fieldOffset(JavaObject.class, (String)"anVolatileField");
        private volatile int anVolatileField = 0;

        public JavaObject(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext threadContext) {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"synchronize"}, visibility=Visibility.PROTECTED)
        public IRubyObject rubySynchronize(ThreadContext threadContext, Block block) {
            JavaObject javaObject = this;
            synchronized (javaObject) {
                return block.yield(threadContext, null);
            }
        }

        @JRubyMethod(name={"ns_wait"}, optional=1, visibility=Visibility.PROTECTED)
        public IRubyObject nsWait(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
            Ruby ruby = threadContext.runtime;
            if (iRubyObjectArray.length > 1) {
                throw ruby.newArgumentError(iRubyObjectArray.length, 1);
            }
            Double d = null;
            if (iRubyObjectArray.length > 0 && !iRubyObjectArray[0].isNil() && (d = Double.valueOf(iRubyObjectArray[0].convertToFloat().getDoubleValue())) < 0.0) {
                throw ruby.newArgumentError("time interval must be positive");
            }
            if (Thread.interrupted()) {
                throw ruby.newConcurrencyError("thread interrupted");
            }
            boolean bl = false;
            try {
                bl = threadContext.getThread().wait_timeout((IRubyObject)this, d);
            }
            catch (InterruptedException interruptedException) {
                throw ruby.newConcurrencyError(interruptedException.getLocalizedMessage());
            }
            finally {
                if (!bl) {
                    ((Object)((Object)this)).notify();
                }
            }
            return this;
        }

        @JRubyMethod(name={"ns_signal"}, visibility=Visibility.PROTECTED)
        public IRubyObject nsSignal(ThreadContext threadContext) {
            ((Object)((Object)this)).notify();
            return this;
        }

        @JRubyMethod(name={"ns_broadcast"}, visibility=Visibility.PROTECTED)
        public IRubyObject nsBroadcast(ThreadContext threadContext) {
            ((Object)((Object)this)).notifyAll();
            return this;
        }

        @JRubyMethod(name={"ensure_ivar_visibility!"}, visibility=Visibility.PROTECTED)
        public IRubyObject ensureIvarVisibilityBang(ThreadContext threadContext) {
            if (UnsafeHolder.U == null) {
                throw new UnsupportedOperationException();
            }
            if (UnsafeHolder.SUPPORTS_FENCES) {
                UnsafeHolder.fullFence();
            } else {
                UnsafeHolder.U.putIntVolatile((Object)this, AN_VOLATILE_FIELD_OFFSET, 1);
                UnsafeHolder.U.getIntVolatile((Object)this, AN_VOLATILE_FIELD_OFFSET);
            }
            return threadContext.nil;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"instance_variable_get_volatile"}, visibility=Visibility.PROTECTED)
        public IRubyObject instanceVariableGetVolatile(ThreadContext threadContext, IRubyObject iRubyObject) {
            if (UnsafeHolder.U == null) {
                JavaObject javaObject = this;
                synchronized (javaObject) {
                    return this.instance_variable_get(threadContext, iRubyObject);
                }
            }
            if (UnsafeHolder.SUPPORTS_FENCES) {
                UnsafeHolder.loadFence();
                return this.instance_variable_get(threadContext, iRubyObject);
            }
            UnsafeHolder.U.getIntVolatile((Object)this, AN_VOLATILE_FIELD_OFFSET);
            return this.instance_variable_get(threadContext, iRubyObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JRubyMethod(name={"instance_variable_set_volatile"}, visibility=Visibility.PROTECTED)
        public IRubyObject InstanceVariableSetVolatile(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            if (UnsafeHolder.U == null) {
                JavaObject javaObject = this;
                synchronized (javaObject) {
                    return this.instance_variable_set(iRubyObject, iRubyObject2);
                }
            }
            if (UnsafeHolder.SUPPORTS_FENCES) {
                IRubyObject iRubyObject3 = this.instance_variable_set(iRubyObject, iRubyObject2);
                UnsafeHolder.storeFence();
                return iRubyObject3;
            }
            IRubyObject iRubyObject4 = this.instance_variable_set(iRubyObject, iRubyObject2);
            UnsafeHolder.U.putIntVolatile((Object)this, AN_VOLATILE_FIELD_OFFSET, 1);
            return iRubyObject4;
        }
    }
}

