/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import java.util.Vector;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Substitution;

public final class Util {
    public static final int SUBSTITUTE_ALL = -1;
    public static final int SPLIT_ALL = 0;

    public static final Vector split(PatternMatcher matcher, Pattern pattern, String input, int limit) {
        Vector<String> results = new Vector<String>(20);
        PatternMatcherInput pinput = new PatternMatcherInput(input);
        int beginOffset = 0;
        while (--limit != 0 && matcher.contains(pinput, pattern)) {
            MatchResult currentResult = matcher.getMatch();
            results.addElement(input.substring(beginOffset, currentResult.beginOffset(0)));
            beginOffset = currentResult.endOffset(0);
        }
        results.addElement(input.substring(beginOffset, input.length()));
        return results;
    }

    public static final Vector split(PatternMatcher matcher, Pattern pattern, String input) {
        return Util.split(matcher, pattern, input, 0);
    }

    public static final String substitute(PatternMatcher matcher, Pattern pattern, Substitution sub, String input, int numSubs) {
        StringBuffer buffer = new StringBuffer(input.length());
        PatternMatcherInput pinput = new PatternMatcherInput(input);
        int subCount = 0;
        int beginOffset = 0;
        while (numSubs != 0 && matcher.contains(pinput, pattern)) {
            --numSubs;
            MatchResult currentResult = matcher.getMatch();
            buffer.append(input.substring(beginOffset, currentResult.beginOffset(0)));
            sub.appendSubstitution(buffer, currentResult, ++subCount, input, matcher, pattern);
            beginOffset = currentResult.endOffset(0);
        }
        if (subCount == 0) {
            return input;
        }
        buffer.append(input.substring(beginOffset, input.length()));
        return buffer.toString();
    }

    public static final String substitute(PatternMatcher matcher, Pattern pattern, Substitution sub, String input) {
        return Util.substitute(matcher, pattern, sub, input, 1);
    }

    private Util() {
    }
}

