/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import org.python.core.ArgParser;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.ThreadState;

public class exceptions
implements ClassDictInit {
    public static String __doc__ = "Python's standard exception class hierarchy.\n\nHere is a rundown of the class hierarchy.  The classes found here are\ninserted into both the exceptions module and the `built-in' module. It is\nrecommended that user defined class based exceptions be derived from the\n`Exception' class, although this is currently not enforced.\n\nException\n |\n +-- SystemExit\n +-- StandardError\n |    |\n |    +-- KeyboardInterrupt\n |    +-- ImportError\n |    +-- EnvironmentError\n |    |    |\n |    |    +-- IOError\n |    |    +-- OSError\n |    |         |\n |    |         +-- WindowsError\n |    |\n |    +-- EOFError\n |    +-- RuntimeError\n |    |    |\n |    |    +-- NotImplementedError\n |    |\n |    +-- NameError\n |    |    |\n |    |    +-- UnboundLocalError\n |    |\n |    +-- AttributeError\n |    +-- SyntaxError\n |    |    |\n |    |    +-- IndentationError\n |    |         |\n |    |         +-- TabError\n |    |\n |    +-- TypeError\n |    +-- AssertionError\n |    +-- LookupError\n |    |    |\n |    |    +-- IndexError\n |    |    +-- KeyError\n |    |\n |    +-- ArithmeticError\n |    |    |\n |    |    +-- OverflowError\n |    |    +-- ZeroDivisionError\n |    |    +-- FloatingPointError\n |    |\n |    +-- ValueError\n |    |    |\n |    |    +-- UnicodeError\n |    |\n |    +-- SystemError\n |    +-- MemoryError\n |\n +---Warning\n      |\n      +-- UserWarning\n      +-- DeprecationWarning\n      +-- SyntaxWarning\n      +-- RuntimeWarning";
    private static /* synthetic */ Class class$Lorg$python$core$exceptions;

    public static void classDictInit(PyObject dict) {
        dict.invoke("clear");
        dict.__setitem__("__name__", (PyObject)new PyString("exceptions"));
        dict.__setitem__("__doc__", (PyObject)new PyString(__doc__));
        ThreadState ts = Py.getThreadState();
        if (ts.systemState == null) {
            ts.systemState = Py.defaultSystemState;
        }
        PyFrame frame = new PyFrame(null, new PyStringMap());
        frame.f_back = ts.frame;
        if (frame.f_builtins == null) {
            frame.f_builtins = frame.f_back != null ? frame.f_back.f_builtins : ts.systemState.builtins;
        }
        ts.frame = frame;
        exceptions.buildClass(dict, "Exception", null, "Exception", "Proposed base class for all exceptions.");
        exceptions.buildClass(dict, "StandardError", "Exception", "empty__init__", "Base class for all standard Python exceptions.");
        exceptions.buildClass(dict, "SyntaxError", "StandardError", "SyntaxError", "Invalid syntax");
        exceptions.buildClass(dict, "IndentationError", "SyntaxError", "empty__init__", "Improper indentation");
        exceptions.buildClass(dict, "TabError", "IndentationError", "empty__init__", "Improper mixture of spaces and tabs.");
        exceptions.buildClass(dict, "EnvironmentError", "StandardError", "EnvironmentError", "Base class for I/O related errors.");
        exceptions.buildClass(dict, "IOError", "EnvironmentError", "empty__init__", "I/O operation failed.");
        exceptions.buildClass(dict, "OSError", "EnvironmentError", "empty__init__", "OS system call failed.");
        exceptions.buildClass(dict, "RuntimeError", "StandardError", "empty__init__", "Unspecified run-time error.");
        exceptions.buildClass(dict, "NotImplementedError", "RuntimeError", "empty__init__", "Method or function hasn't been implemented yet.");
        exceptions.buildClass(dict, "SystemError", "StandardError", "empty__init__", "Internal error in the Python interpreter.\n\nPlease report this to the Python maintainer, along with the traceback,\nthe Python version, and the hardware/OS platform and version.");
        exceptions.buildClass(dict, "EOFError", "StandardError", "empty__init__", "Read beyond end of file.");
        exceptions.buildClass(dict, "ImportError", "StandardError", "empty__init__", "Import can't find module, or can't find name in module.");
        exceptions.buildClass(dict, "TypeError", "StandardError", "empty__init__", "Inappropriate argument type.");
        exceptions.buildClass(dict, "ValueError", "StandardError", "empty__init__", "Inappropriate argument value (of correct type).");
        exceptions.buildClass(dict, "UnicodeError", "ValueError", "empty__init__", "Unicode related error.");
        exceptions.buildClass(dict, "KeyboardInterrupt", "StandardError", "empty__init__", "Program interrupted by user.");
        exceptions.buildClass(dict, "AssertionError", "StandardError", "empty__init__", "Assertion failed.");
        exceptions.buildClass(dict, "ArithmeticError", "StandardError", "empty__init__", "Base class for arithmetic errors.");
        exceptions.buildClass(dict, "OverflowError", "ArithmeticError", "empty__init__", "Result too large to be represented.");
        exceptions.buildClass(dict, "FloatingPointError", "ArithmeticError", "empty__init__", "Floating point operation failed.");
        exceptions.buildClass(dict, "ZeroDivisionError", "ArithmeticError", "empty__init__", "Second argument to a division or modulo operation was zero.");
        exceptions.buildClass(dict, "LookupError", "StandardError", "empty__init__", "Base class for lookup errors.");
        exceptions.buildClass(dict, "IndexError", "LookupError", "empty__init__", "Sequence index out of range.");
        exceptions.buildClass(dict, "KeyError", "LookupError", "empty__init__", "Mapping key not found.");
        exceptions.buildClass(dict, "AttributeError", "StandardError", "empty__init__", "Attribute not found.");
        exceptions.buildClass(dict, "NameError", "StandardError", "empty__init__", "Name not found globally.");
        exceptions.buildClass(dict, "UnboundLocalError", "NameError", "empty__init__", "Local name referenced but not bound to a value.");
        exceptions.buildClass(dict, "MemoryError", "StandardError", "empty__init__", "Out of memory.");
        exceptions.buildClass(dict, "SystemExit", "Exception", "SystemExit", "Request to exit from the interpreter.");
        exceptions.buildClass(dict, "Warning", "Exception", "empty__init__", "Base class for warning categories.");
        exceptions.buildClass(dict, "UserWarning", "Warning", "empty__init__", "Base class for warnings generated by user code.");
        exceptions.buildClass(dict, "DeprecationWarning", "Warning", "empty__init__", "Base class for warnings about deprecated features.");
        exceptions.buildClass(dict, "SyntaxWarning", "Warning", "empty__init__", "Base class for warnings about dubious syntax.");
        exceptions.buildClass(dict, "RuntimeWarning", "Warning", "empty__init__", "Base class for warnings about dubious runtime behavior.");
        ts.frame = ts.frame.f_back;
    }

    public static PyObject empty__init__(PyObject[] arg, String[] kws) {
        PyStringMap dict = new PyStringMap();
        ((PyObject)dict).__setitem__("__module__", (PyObject)new PyString("exceptions"));
        return dict;
    }

    public static PyObject Exception(PyObject[] arg, String[] kws) {
        PyObject dict = exceptions.empty__init__(arg, kws);
        dict.__setitem__("__init__", exceptions.getJavaFunc("Exception__init__"));
        dict.__setitem__("__str__", exceptions.getJavaFunc("Exception__str__"));
        dict.__setitem__("__getitem__", exceptions.getJavaFunc("Exception__getitem__"));
        return dict;
    }

    public static void Exception__init__(PyObject[] arg, String[] kws) {
        ArgParser ap = new ArgParser("__init__", arg, kws, "self", "args");
        PyObject self = ap.getPyObject(0);
        PyObject args = ap.getList(1);
        self.__setattr__("args", args);
    }

    public static PyString Exception__str__(PyObject[] arg, String[] kws) {
        ArgParser ap = new ArgParser("__str__", arg, kws, "self");
        PyObject self = ap.getPyObject(0);
        PyObject args = self.__getattr__("args");
        if (!args.__nonzero__()) {
            return new PyString("");
        }
        if (args.__len__() == 1) {
            return args.__getitem__(0).__str__();
        }
        return args.__str__();
    }

    public static PyObject Exception__getitem__(PyObject[] arg, String[] kws) {
        ArgParser ap = new ArgParser("__getitem__", arg, kws, "self", "i");
        PyObject self = ap.getPyObject(0);
        PyObject i = ap.getPyObject(1);
        return self.__getattr__("args").__getitem__(i);
    }

    public static PyObject SyntaxError(PyObject[] arg, String[] kws) {
        PyObject __dict__ = exceptions.empty__init__(arg, kws);
        __dict__.__setitem__("filename", Py.None);
        __dict__.__setitem__("lineno", Py.None);
        __dict__.__setitem__("offset", Py.None);
        __dict__.__setitem__("text", Py.None);
        __dict__.__setitem__("msg", (PyObject)new PyString(""));
        __dict__.__setitem__("__init__", exceptions.getJavaFunc("SyntaxError__init__"));
        __dict__.__setitem__("__str__", exceptions.getJavaFunc("SyntaxError__str__"));
        return __dict__;
    }

    public static void SyntaxError__init__(PyObject[] arg, String[] kws) {
        ArgParser ap = new ArgParser("__init__", arg, kws, "self", "args");
        PyObject self = ap.getPyObject(0);
        PyObject args = ap.getList(1);
        self.__setattr__("args", args);
        if (args.__len__() >= 1) {
            self.__setattr__("msg", args.__getitem__(0));
        }
        if (args.__len__() == 2) {
            PyObject info = args.__getitem__(1);
            try {
                PyObject[] tmp = Py.unpackSequence(info, 4);
                self.__setattr__("filename", tmp[0]);
                self.__setattr__("lineno", tmp[1]);
                self.__setattr__("offset", tmp[2]);
                self.__setattr__("text", tmp[3]);
            }
            catch (PyException exc) {
                // empty catch block
            }
        }
    }

    public static PyString SyntaxError__str__(PyObject[] arg, String[] kws) {
        ArgParser ap = new ArgParser("__init__", arg, kws, "self", "args");
        PyObject self = ap.getPyObject(0);
        PyString str = self.__getattr__("msg").__str__();
        PyObject filename = exceptions.basename(self.__findattr__("filename"));
        PyObject lineno = self.__findattr__("lineno");
        if (filename instanceof PyString && lineno instanceof PyInteger) {
            return new PyString(str + " (" + filename + ", line " + lineno + ")");
        }
        if (filename instanceof PyString) {
            return new PyString(str + " (" + filename + ")");
        }
        if (lineno instanceof PyInteger) {
            return new PyString(str + " (line " + lineno + ")");
        }
        return str;
    }

    private static final PyObject basename(PyObject filename) {
        int i;
        if (filename instanceof PyString && (i = ((PyString)filename).rfind(File.separator)) >= 0) {
            return filename.__getslice__(new PyInteger(i + 1), new PyInteger(Integer.MAX_VALUE));
        }
        return filename;
    }

    public static PyObject EnvironmentError(PyObject[] arg, String[] kws) {
        PyObject dict = exceptions.empty__init__(arg, kws);
        dict.__setitem__("__init__", exceptions.getJavaFunc("EnvironmentError__init__"));
        dict.__setitem__("__str__", exceptions.getJavaFunc("EnvironmentError__str__"));
        return dict;
    }

    public static void EnvironmentError__init__(PyObject[] arg, String[] kws) {
        PyObject[] tmp;
        ArgParser ap = new ArgParser("__init__", arg, kws, "self", "args");
        PyObject self = ap.getPyObject(0);
        PyObject args = ap.getList(1);
        self.__setattr__("args", args);
        self.__setattr__("errno", Py.None);
        self.__setattr__("strerror", Py.None);
        self.__setattr__("filename", Py.None);
        if (args.__len__() == 3) {
            tmp = Py.unpackSequence(args, 3);
            self.__setattr__("errno", tmp[0]);
            self.__setattr__("strerror", tmp[1]);
            self.__setattr__("filename", tmp[2]);
            self.__setattr__("args", args.__getslice__(Py.Zero, Py.newInteger(2), Py.One));
        }
        if (args.__len__() == 2) {
            tmp = Py.unpackSequence(args, 2);
            self.__setattr__("errno", tmp[0]);
            self.__setattr__("strerror", tmp[1]);
        }
    }

    public static PyString EnvironmentError__str__(PyObject[] arg, String[] kws) {
        ArgParser ap = new ArgParser("__init__", arg, kws, "self");
        PyObject self = ap.getPyObject(0);
        if (self.__getattr__("filename") != Py.None) {
            return Py.newString("[Errno %s] %s: %s").__mod__(new PyTuple(new PyObject[]{self.__getattr__("errno"), self.__getattr__("strerror"), self.__getattr__("filename")})).__str__();
        }
        if (self.__getattr__("errno").__nonzero__() && self.__getattr__("strerror").__nonzero__()) {
            return Py.newString("[Errno %s] %s").__mod__(new PyTuple(new PyObject[]{self.__getattr__("errno"), self.__getattr__("strerror")})).__str__();
        }
        return exceptions.Exception__str__(arg, kws);
    }

    public static PyObject SystemExit(PyObject[] arg, String[] kws) {
        PyObject dict = exceptions.empty__init__(arg, kws);
        dict.__setitem__("__init__", exceptions.getJavaFunc("SystemExit__init__"));
        return dict;
    }

    public static void SystemExit__init__(PyObject[] arg, String[] kws) {
        ArgParser ap = new ArgParser("__init__", arg, kws, "self", "args");
        PyObject self = ap.getPyObject(0);
        PyObject args = ap.getList(1);
        self.__setattr__("args", args);
        if (args.__len__() == 0) {
            self.__setattr__("code", Py.None);
        } else if (args.__len__() == 1) {
            self.__setattr__("code", args.__getitem__(0));
        } else {
            self.__setattr__("code", args);
        }
    }

    private static final PyObject getJavaFunc(String name) {
        return Py.newJavaFunc(class$Lorg$python$core$exceptions != null ? class$Lorg$python$core$exceptions : (class$Lorg$python$core$exceptions = exceptions.class$("org.python.core.exceptions")), name);
    }

    private static final PyObject buildClass(PyObject dict, String classname, String superclass, String classCodeName, String doc) {
        PyObject[] sclass = Py.EmptyObjects;
        if (superclass != null) {
            sclass = new PyObject[]{dict.__getitem__(new PyString(superclass))};
        }
        PyObject cls = Py.makeClass(classname, sclass, Py.newJavaCode(class$Lorg$python$core$exceptions != null ? class$Lorg$python$core$exceptions : (class$Lorg$python$core$exceptions = exceptions.class$("org.python.core.exceptions")), classCodeName), new PyString(doc));
        dict.__setitem__(classname, cls);
        return cls;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private exceptions() {
    }
}

