/*  Part of SWI-Prolog

    Author:        Jan Wielemaker
    E-mail:        J.Wielemaker@uva.nl
    WWW:           http://www.swi-prolog.org
    Copyright (C): 2010, University of Amsterdam

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    As a special exception, if you link this library with other files,
    compiled with a Free Software compiler, to produce an executable, this
    library does not by itself cause the resulting executable to be covered
    by the GNU General Public License. This exception does not however
    invalidate any other reasons why the executable file might be covered by
    the GNU General Public License.
*/

:- module(ciao_terms,
	  [ copy_args/3,		% +N, ?Term, ?Copy
	    arg/2,			% +Term, ?Arg
	    atom_concat/2		% +Atms, -Atm
	  ]).

/** <module> Ciao Prolog compatible library(terms)

@deprecated	A library with the same name is used in SWI and other
		systems with very different functionality.
*/

%%	copy_args(+N, ?Term, ?Copy) is semidet.
%
%	Term and Copy have the same first N arguments.

copy_args(N, Term, Copy) :-
	N >= 1, !,
	arg(N, Term, A),
	arg(N, Copy, A),
	N2 is N - 1,
	copy_args(N2, Term, Copy).
copy_args(_, _, _).

%%	arg(+Term, ?Arg) is nondet.
%
%	Arg is an argument of  Term.  Gives   each  of  the arguments on
%	backtracking.

arg(Term, Arg) :-
	arg(_, Term, Arg).

%%	atom_concat(+Atms, -Atm) is det.
%
%	Atm is the atom resulting from   concatenating  all atoms in the
%	list Atms in the order in which they appear.

atom_concat(Atms, Atm) :-
	atomic_list_concat(Atms, Atm).
