/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.lifecycle;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.linkedin.util.annotations.Initializer;
import org.linkedin.util.lifecycle.Shutdown;
import org.linkedin.util.reflect.ObjectProxy;
import org.linkedin.util.reflect.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownProxy
implements InvocationHandler,
Serializable,
ObjectProxy {
    private static final long serialVersionUID = 1L;
    public static final String MODULE = ShutdownProxy.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private Object _object;
    private Shutdown _shutdown;

    public ShutdownProxy(Object object, Shutdown shutdown) {
        this._object = object;
        this._shutdown = shutdown;
    }

    public ShutdownProxy() {
    }

    public Object getObject() {
        return this._object;
    }

    @Initializer(required=true)
    public void setObject(Object object) {
        this._object = object;
    }

    public Shutdown getShutdown() {
        return this._shutdown;
    }

    @Initializer(required=true)
    public void setShutdown(Shutdown shutdown) {
        this._shutdown = shutdown;
    }

    public Object getProxiedObject() {
        return this._object;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        this._shutdown.startCall();
        try {
            Object object = method.invoke(this._object, objects);
            return object;
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            try {
                throw th;
            }
            catch (Exception ex) {
                throw ex;
            }
            catch (Throwable throwable) {
                log.error(method.toString(), throwable);
                throw throwable;
            }
        }
        finally {
            this._shutdown.endCall();
        }
    }

    public static Object createShutdownProxy(Object o, Shutdown shutdown) {
        return ShutdownProxy.createShutdownProxy(o, null, shutdown);
    }

    public static Object createShutdownProxy(Object o, Class[] interfaces, Shutdown shutdown) {
        if (interfaces == null) {
            interfaces = ReflectUtils.extractAllInterfaces(o);
        }
        return Proxy.newProxyInstance(o.getClass().getClassLoader(), interfaces, (InvocationHandler)new ShutdownProxy(o, shutdown));
    }
}

