/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.endpoints;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.message.MessageInputStream;
import org.eclipse.jetty.websocket.common.message.MessageReader;
import org.eclipse.jetty.websocket.jsr356.JsrPongMessage;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.MessageHandlerWrapper;
import org.eclipse.jetty.websocket.jsr356.MessageType;
import org.eclipse.jetty.websocket.jsr356.endpoints.AbstractJsrEventDriver;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.messages.BinaryPartialMessage;
import org.eclipse.jetty.websocket.jsr356.messages.BinaryWholeMessage;
import org.eclipse.jetty.websocket.jsr356.messages.TextPartialMessage;
import org.eclipse.jetty.websocket.jsr356.messages.TextWholeMessage;

public class JsrEndpointEventDriver
extends AbstractJsrEventDriver {
    private static final Logger LOG = Log.getLogger(JsrEndpointEventDriver.class);
    private final Endpoint endpoint;
    private Map<String, String> pathParameters;

    public JsrEndpointEventDriver(WebSocketPolicy policy, EndpointInstance endpointInstance) {
        super(policy, endpointInstance);
        this.endpoint = (Endpoint)endpointInstance.getEndpoint();
    }

    @Override
    public void init(JsrSession jsrsession) {
        jsrsession.setPathParameters(this.pathParameters);
    }

    @Override
    public void onBinaryFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            final MessageHandlerWrapper wrapper = this.jsrsession.getMessageHandlerWrapper(MessageType.BINARY);
            if (wrapper == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No BINARY MessageHandler declared", new Object[0]);
                }
                return;
            }
            if (wrapper.wantsPartialMessages()) {
                this.activeMessage = new BinaryPartialMessage(wrapper);
            } else if (wrapper.wantsStreams()) {
                final MessageInputStream stream = new MessageInputStream();
                this.activeMessage = stream;
                this.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        MessageHandler.Whole handler = (MessageHandler.Whole)wrapper.getHandler();
                        handler.onMessage((Object)stream);
                    }
                });
            } else {
                this.activeMessage = new BinaryWholeMessage(this, wrapper);
            }
        }
        this.activeMessage.appendFrame(buffer, fin);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    @Override
    public void onBinaryMessage(byte[] data) {
    }

    @Override
    protected void onClose(CloseReason closereason) {
        this.endpoint.onClose((Session)this.jsrsession, closereason);
    }

    @Override
    public void onConnect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onConnect({}, {})", this.jsrsession, this.config);
        }
        this.endpoint.onOpen((Session)this.jsrsession, this.config);
    }

    @Override
    public void onError(Throwable cause) {
        LOG.warn(cause);
        try {
            this.endpoint.onError((Session)this.jsrsession, cause);
        }
        catch (Throwable t) {
            LOG.warn("Unable to report to onError due to exception", t);
        }
    }

    @Override
    public void onFrame(Frame frame) {
    }

    @Override
    public void onInputStream(InputStream stream) {
    }

    @Override
    public void onReader(Reader reader) {
    }

    @Override
    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            final MessageHandlerWrapper wrapper = this.jsrsession.getMessageHandlerWrapper(MessageType.TEXT);
            if (wrapper == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No TEXT MessageHandler declared", new Object[0]);
                }
                return;
            }
            if (wrapper.wantsPartialMessages()) {
                this.activeMessage = new TextPartialMessage(wrapper);
            } else if (wrapper.wantsStreams()) {
                final MessageReader stream = new MessageReader(new MessageInputStream());
                this.activeMessage = stream;
                this.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        MessageHandler.Whole handler = (MessageHandler.Whole)wrapper.getHandler();
                        handler.onMessage((Object)stream);
                    }
                });
            } else {
                this.activeMessage = new TextWholeMessage(this, wrapper);
            }
        }
        this.activeMessage.appendFrame(buffer, fin);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    @Override
    public void onTextMessage(String message) {
    }

    @Override
    public void onPing(ByteBuffer buffer) {
        this.onPongMessage(buffer);
    }

    @Override
    public void onPong(ByteBuffer buffer) {
        this.onPongMessage(buffer);
    }

    private void onPongMessage(ByteBuffer buffer) {
        MessageHandlerWrapper wrapper = this.jsrsession.getMessageHandlerWrapper(MessageType.PONG);
        if (wrapper == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No PONG MessageHandler declared", new Object[0]);
            }
            return;
        }
        ByteBuffer pongBuf = null;
        if (BufferUtil.isEmpty(buffer)) {
            pongBuf = BufferUtil.EMPTY_BUFFER;
        } else {
            pongBuf = ByteBuffer.allocate(buffer.remaining());
            BufferUtil.put(buffer, pongBuf);
            BufferUtil.flipToFlush(pongBuf, 0);
        }
        MessageHandler.Whole pongHandler = (MessageHandler.Whole)wrapper.getHandler();
        pongHandler.onMessage((Object)new JsrPongMessage(pongBuf));
    }

    @Override
    public void setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
    }

    public String toString() {
        return String.format("%s[%s]", JsrEndpointEventDriver.class.getSimpleName(), this.endpoint.getClass().getName());
    }
}

