"use strict";

var _interopRequire = function (obj) { return obj && obj.__esModule ? obj["default"] : obj; };

var _inherits = function (subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) subClass.__proto__ = superClass; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var Declaration = _interopRequire(require("./declaration"));

var Container = _interopRequire(require("./container"));

var Comment = _interopRequire(require("./comment"));

var AtRule = _interopRequire(require("./at-rule"));

var Result = _interopRequire(require("./result"));

var Rule = _interopRequire(require("./rule"));

// Root of CSS

var Root = (function (Container) {
    function Root(defaults) {
        _classCallCheck(this, Root);

        this.type = "root";
        this.nodes = [];
        Container.call(this, defaults);
    }

    _inherits(Root, Container);

    // Fix space when we remove first child

    Root.prototype.remove = function remove(child) {
        child = this.index(child);

        if (child === 0 && this.nodes.length > 1) {
            this.nodes[1].before = this.nodes[child].before;
        }

        return Container.prototype.remove.call(this, child);
    };

    // Fix spaces on insert before first rule

    Root.prototype.normalize = function normalize(child, sample, type) {
        var nodes = Container.prototype.normalize.call(this, child);

        if (sample) {
            if (type == "prepend") {
                if (this.nodes.length > 1) {
                    sample.before = this.nodes[1].before;
                } else {
                    delete sample.before;
                }
            } else {
                for (var _iterator = nodes, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
                    var _ref;

                    if (_isArray) {
                        if (_i >= _iterator.length) break;
                        _ref = _iterator[_i++];
                    } else {
                        _i = _iterator.next();
                        if (_i.done) break;
                        _ref = _i.value;
                    }

                    var node = _ref;

                    if (this.first != sample) node.before = sample.before;
                }
            }
        }

        return nodes;
    };

    // Stringify styles

    Root.prototype.stringify = function stringify(builder) {
        this.stringifyContent(builder);
        if (this.after) builder(this.after);
    };

    // Generate processing result with optional source map

    Root.prototype.toResult = function toResult() {
        var opts = arguments[0] === undefined ? {} : arguments[0];

        return new Result(this, opts);
    };

    return Root;
})(Container);

module.exports = Root;