'''OpenGL extension AMD.pinned_memory

This module customises the behaviour of the 
OpenGL.raw.GL.AMD.pinned_memory to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension defines an interface that allows improved control
	of the physical memory used by the graphics device.
	
	It allows the an existing page of system memory allocated by the application
	to be used as memory directly accessible graphics processor. One example
	application of this functionality would be to be able to avoid an explicit
	synchronous copy whith sub-system of your application; for instance it is
	possible to directly draw from a system memory copy of a video image.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/AMD/pinned_memory.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.AMD.pinned_memory import *
### END AUTOGENERATED SECTION