module TestHelper

  private

  MATCH_BOUNDARY = /Boundary_\d+\.\d+/
  MATCH_ID_HEADER  = /-ID: <[^>]+>\r\n/

  def assert_equal_mime_message expected, actual
    assert_equal normalize_message(expected), normalize_message(actual)
  end

  def assert_equal_content_type expected, actual
    assert_equal expected.sub(MATCH_BOUNDARY, ''), actual.sub(MATCH_BOUNDARY, '')

  end

  #
  # Make messages comparable by removing *-ID header values and boundaries.
  #
  def normalize_message message
    message.
      gsub(MATCH_ID_HEADER, "-ID:\r\n").
      gsub(MATCH_BOUNDARY, "Boundary_")
  end

  def sd filename
    @scaffold_dir ||= File.join(File.dirname(__FILE__), 'scaffold')
    @scaffold_dir + filename
  end

end
